<?php 
/*
 *	TEMPLATE NAME: Services Page
 *	
 *	Handles output for services archive page
 *
 *	@version 1.0
 *	@since intensely 1.0
 */
 
get_header();
  
$page_title_section	= esc_html( get_post_meta( get_the_ID(), '_intensely_portfolio_template_title_on_off', true ) );
if( $page_title_section == 'intensely-ct-title-on' ) : ?>
	<!-- Start single page header -->
	<section id="single-page-header">
		<div class="overlay">
		    <div class="container">
		        <div class="row">
			        <div class="col-md-6 col-sm-6 col-xs-12">
			            <div class="single-page-header-left">
			              
			              <?php the_title( '<h2>', '</h2>' ); ?>
			              
							<!-- start loop -->											
							<?php 
								if (have_posts()) :
									while (have_posts()) : the_post();
									
										the_content();
									
									endwhile;
								endif;
							?>
							<!-- end loop -->
			              
			            </div>
			        </div>
			        
			        <?php if ( function_exists('yoast_breadcrumb') ) { ?>
				        <div class="col-md-6 col-sm-6 col-xs-12">
				            <div class="single-page-header-right">
								<!-- start breadcrumb -->
								<?php yoast_breadcrumb('<p class="breadcrumb">','</p>'); ?>
								<!-- End breadcrumb -->
				            </div>
				        </div>
			        <?php } ?>
			        
		        </div>
		    </div>
		</div>
	</section>
	<!-- End single page header -->
<?php endif; ?>

<!-- Start Service -->
<section id="service">
	<div class="container">
	    <div class="row">
	        
	        <div class="col-md-12">
		        <div class="service-content">
		            <div class="row">
			            
					<!-- Start services -->
					<?php
						
						$services = get_theme_mod( 'intensely_services_option', array() );
						
						if( $services ){
						
							/*
							 *	Start counter loop
							 */
							foreach ( $services as $service_item ) {
							
							/*
							 *	set counters variables
							 */
							$service_icon		=	esc_html( $service_item['intensely_service_icon'] );		// counter icon
							$service_title		=	esc_html( $service_item['intensely_service_title'] );		// counter number
							$service_desc		=	esc_textarea( $service_item['intensely_service_desc'] );	// counter text
						?>
			            
					            <!-- Start single service -->
					            <div class="col-md-4 col-sm-6">
					                <div class="single-service">
					                  <i class="fa <?php echo $service_icon; ?> service-icon"></i>
					                  <h4 class="service-title"><?php echo $service_title; ?></h4>
					                  <p><?php echo $service_desc; ?></p>
					                </div>
					            </div>
					            <!-- End single service -->
			            
							<?php } ?>
			            <?php } ?>
			            
		            </div>
		        </div>
	        </div>
	        
	        
	    </div>
	</div>
</section>
<!-- End Service -->

<!-- Start subscribe us -->
<?php echo get_template_part( 'inc/template-parts/subscribe', 'form' ); ?>
<!-- End subscribe us -->

<?php get_footer(); ?>