<?php 
/*
 *	TEMPLATE NAME: Portfolio Page
 *	
 *	Handles output for portfolio archive page
 *
 *	@version 1.0
 *	@since intensely 1.0
 */

get_header();
	
$page_title_section	= esc_html( get_post_meta( get_the_ID(), '_intensely_portfolio_template_title_on_off', true ) );
if( $page_title_section == 'intensely-ct-title-on' ) : ?>
  	<!-- Start single page header -->
  	<section id="single-page-header">
	    <div class="overlay">
		    <div class="container">
		        <div class="row">
			        <div class="col-md-6 col-sm-6 col-xs-12">
			            <div class="single-page-header-left">
			              
			              <?php the_title( '<h2>', '</h2>' ); ?>
			              
							<!-- start loop -->											
							<?php 
								if (have_posts()) :
									while (have_posts()) : the_post();
									
										the_content();
									
									endwhile;
								endif;
							?>
							<!-- end loop -->
			              
			            </div>
			        </div>
			        
			        <?php if ( function_exists('yoast_breadcrumb') ) { ?>
				        <div class="col-md-6 col-sm-6 col-xs-12">
				            <div class="single-page-header-right">
								<!-- start breadcrumb -->
								<?php yoast_breadcrumb('<p class="breadcrumb">','</p>'); ?>
								<!-- End breadcrumb -->
				            </div>
				        </div>
			        <?php } ?>
			        
		        </div>
		    </div>
	    </div>
	</section>
	<!-- End single page header -->
<?php endif; ?>

<!-- Start portfolio -->
<section id="portfolio">
	<div class="container">
	   <div class="row">
		   
		   <div class="col-md-12">
			    <div class="portfolio-area home-portfolio intensely-custom-template">     
			       	<!-- Portfolio container -->
			       	<div class="portfolio-container">
				       	
						<?php
							/*
							 *	Set vars for portfolio post type query
							 *
							 *	@intensely 1.0
							 */
							$portfolio_count			=	esc_html( get_theme_mod( 'intensely_portfolio_display_count', 4 ) );
							$portfolio_display_order	=	esc_html( get_theme_mod( 'intensely_portfolio_display_order', 'DESC' ) );
							
							$portfolio_args = array( 
								'post_type' 			=> 'intensely-portfolio', 
								'posts_per_page' 		=> $portfolio_count,
								'ignore_sticky_posts'	=> 1,
								'order'     			=> $portfolio_display_order, //DESC - ASC
							);	
	
							$portfolio_loop = new WP_Query( $portfolio_args );
								
							if ( $portfolio_loop -> have_posts() ) :	
								while ( $portfolio_loop->have_posts() ) : $portfolio_loop->the_post(); ?>
							    
							        <div class="single-portfolio"> 
							           	<div class="single-item">
							             	<?php the_post_thumbnail( 'intensely-portfolio-thumb', array( 'alt' => esc_attr( get_the_title() ) ) ); ?>
								            <div class="single-item-content">               
									            <a class="view-icon" href="#"><i class="fa fa-search-plus"></i></a>
												<div class="portfolio-title">
									                <?php the_title( '<h4>', '</h4>' );?>
													<?php display_portfolio_taxonomy_terms('intensely-portfolio-taxonomy'); ?>
												</div>
									           	<div class="portfolio-detail">
								                    <a href="#" class="modal-close-btn"><span class="fa fa-times"></span></a>
								                    <?php the_post_thumbnail( 'intensely-portfolio-thumb', array( 'alt' => esc_attr( get_the_title() ) ) ); ?>
								                    <?php the_title( '<h4>', '</h4>' );?>
								                    <?php the_content(); ?>
													<?php									                    
														/*
														 *  Portfolio Meta
														 *	set variables
														 *
														 *	@since intensely 1.0
														 */
														$button_text 			= esc_html( get_post_meta( get_the_ID(), '_intensely_portfolio_demo_btn_text', true ) );
														$button_url 			= esc_url( get_post_meta( get_the_ID(), '_intensely_portfolio_demo_btn_url', true ) );
														$button_target_value 	= esc_html( get_post_meta( get_the_ID(), '_intensely_portfolio_demo_btn_target', true ) );
														$button_target			= ( $button_target_value ) ? '_blank' : '_self' ;
													?>
								                    
								                    <?php if( $button_text && $button_url ): ?>
								                    	<a href="<?php echo $button_url; ?>" class="view-project-btn" target="<?php echo $button_target;?>"><?php echo $button_text; ?></a>
								                    <?php endif; ?>
								                    
									            </div>
											</div>
										</div>
								    </div>								
					
						<?php
							    endwhile;
							endif;
							wp_reset_postdata(); 
						?>
					         
					</div>        
			    </div>
		   </div>
		   
	   </div>
	</div>
</section>
<!-- End portfolio -->

<!-- Start subscribe us -->
<?php echo get_template_part( 'inc/template-parts/subscribe', 'form' ); ?>
<!-- End subscribe us -->

<?php get_footer(); ?>