<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 *	@version 1.0
 *	@since intensely 1.0
 */

get_header(); ?>
  
	<!-- Start blog archive -->
  	<section id="blog-archive">
	    <div class="container">
		    <div class="row">
		        <div class="col-md-12">
			        <div class="blog-archive-area">
			            <div class="row">
				            <div class="col-md-8">
				                <div class="blog-archive-left">
					                
									<!-- start loop -->											
									<?php 
										if ( have_posts() ) :
											while (have_posts()) : the_post();	?>
											
				                  	<!-- Start blog news single -->
				                  	<article class="blog-news-single">
									    <?php if( has_post_thumbnail() ): ?>
										    <div class="blog-news-img">
											    <?php the_post_thumbnail( 'post-thumbnail', array( 'alt' => esc_attr( get_the_title() ) ) ); ?>
										    </div>
									    <?php endif; ?>
									    
									    <div class="blog-news-title">
										    <?php the_title( '<h2>', '</h2>' ); ?>
											<?php get_template_part( 'post', 'meta' ); ?>
									    </div>	
															                
						                <div class="blog-news-details blog-single-details">
											<?php the_content(); ?>
											<?php get_template_part( 'inc/template-parts/post', 'tags' ); ?>
					                    </div>
					                    
			                          <!-- Single Post Pagination-->							  
									  <?php 
									  
										wp_link_pages( array(
											'before'      => '<div class="singlepost-pagination"><span>'. __( 'Pages:', 'intensely' ) .'</span>',
											'after'       => '</div>',
											'link_before' => '<span>',
											'link_after'  => '</span>',
										) );								  
									  
									  ?>				                    
						                
				                  	</article>
								  	
								  	<?php get_template_part( 'inc/template-parts/next', 'prev' );?>
								  	<?php get_template_part( 'inc/template-parts/author', 'bio' ); ?>
								  	<?php get_template_part( 'inc/template-parts/related', 'posts' ); ?>
								  	
									<?php
										/*
										 *	If comments are open or we have at least one comment, load up the comment template.
										 *
										 *	@since intensely 1.0
										 */
										if ( comments_open() || get_comments_number() ) :
											comments_template();
										endif;	?>
								  	
					                
									<?php		
											endwhile;
											
											else : 
											
												get_template_part( 'content', 'none' );
										endif;
									?>
									<!-- end loop -->
					                
				                </div>
				            </div>
				            
				            <div class="col-md-4">
					            <?php get_sidebar(); ?>
				            </div>
				            
			            </div>
			        </div>
		        </div>
		    </div>
	    </div>  
  	</section>
  	<!-- End blog archive -->

<!-- Start subscribe us -->
<?php echo get_template_part( 'inc/template-parts/subscribe', 'form' ); ?>
<!-- End subscribe us -->

<?php get_footer(); ?>