<?php
/**
 * The default template for displaying post meta
 *
 * Used for index/archive/search.
 *
 *	@version 1.0
 *	@since intensely 1.0
 */
?>
  <p>
	<?php
		/*
		 *	On/off author name
		 */
		 $post_author_name	=	esc_html( get_theme_mod( 'intensely_blog_meta_author', '0' ) );
		 if( $post_author_name == '0' ):
	?>  
			<i class="fa fa-user" aria-hidden="true"></i> <a class="blog-author" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>">
				<?php the_author(); ?></a> 
	<?php endif; ?>
	
	<?php
		/*
		 *	On/off post date
		 */
		 $post_date	=	esc_html( get_theme_mod( 'intensely_blog_meta_date', '0' ) );
		 if( $post_date == '0' ):
	?>  
			<span class="blog-date"><i class="fa fa-clock-o" aria-hidden="true"></i> <?php the_time( get_option( 'date_format' ) ); ?></span>
	<?php endif; ?>
	
	<?php
		/*
		 *	On/off category
		 */
		 $post_cat	=	esc_html( get_theme_mod( 'intensely_blog_meta_cat', '0' ) );
		 if( $post_cat == '0' ):
	?>  
		<i class="fa fa-th-large" aria-hidden="true"></i> <?php the_category('<span>/</span> '); ?>
	<?php endif; ?>
	
	<?php
		/*
		 *	On/off post comment count
		 */
		 $post_comment_count	=	esc_html( get_theme_mod( 'intensely_blog_single_comments_count', '0' ) );
		 if( $post_comment_count == '0' ):
	?>  
		<?php if ( comments_open() ) :  ?>
			<i class="fa fa-comments-o" aria-hidden="true"></i> 
				<?php 
					comments_popup_link( 
						__('0', 'intensely'), 
						__('1', 'intensely'), 
						__('%', 'intensely') 
					); 
				?>
		<?php endif; ?>
	<?php endif; ?>
	
	<?php edit_post_link( __(' Edit', 'intensely' ), '<i class="fa fa-pencil" aria-hidden="true"></i>', '' ); ?>
  </p>
