<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 *	@version 1.0
 *	@since intensely 1.0
 */

get_header(); ?>

<!-- Start blog archive -->
<section id="blog-archive">
    <div class="container">
	    <div class="row">
	        <div class="col-md-12">
		        <div class="blog-archive-area">
		            <div class="row">
			            <div class="col-md-8">
			                <div class="blog-archive-left">
				                
								<!-- start loop -->											
								<?php 
									if ( have_posts() ) :
									
										while (have_posts()) : the_post();
										
											get_template_part( 'content', '' );
										
										endwhile;
										
										else : 
										
											get_template_part( 'content', 'none' );
									endif;
								?>
								<!-- end loop -->
				                  
			                  
								<!-- Start blog pagination -->
								<div class="blog-pagination">
				                    <?php echo intensely_numeric_page_navi(); ?>
				                </div>
				                
				            </div>
				        </div>
				        
			            <div class="col-md-4">
				            <?php get_sidebar(); ?>
			            </div>
			            
		            </div>
		        </div>
	        </div>
	    </div>
    </div>  
</section>
<!-- End blog archive -->

<!-- Start subscribe us -->
<?php echo get_template_part( 'inc/template-parts/subscribe', 'form' ); ?>
<!-- End subscribe us -->

<?php get_footer(); ?>