<?php
/**
 * Easy Digital Downloads Theme Updater
 *
 * @package EDD Sample Theme
 */

// Includes the files needed for the theme updater
if ( !class_exists( 'EDD_Theme_Updater_Admin' ) ) {
	include( dirname( __FILE__ ) . '/theme-updater-admin.php' );
}

// Loads the updater classes
$updater = new EDD_Theme_Updater_Admin(

	// Config settings
	$config = array(
		'remote_api_url' => 'https://www.wpfreeware.com', // Site where EDD is hosted
		'item_name'      => 'Intensely', // Name of theme
		'theme_slug'     => 'intensely', // Theme slug
		'version'        => '1.0', // The current version of this theme
		'author'         => 'WpFreeware', // The author of this theme
		'download_id'    => '', // Optional, used for generating a license renewal link
		'renew_url'      => '', // Optional, allows for a custom license renewal link
		'beta'           => false, // Optional, set to true to opt into beta versions
	),

	// Strings
	$strings = array(
		'theme-license'             => __( 'Theme License', 'intensely' ),
		'enter-key'                 => __( 'Enter your theme license key.', 'intensely' ),
		'license-key'               => __( 'License Key', 'intensely' ),
		'license-action'            => __( 'License Action', 'intensely' ),
		'deactivate-license'        => __( 'Deactivate License', 'intensely' ),
		'activate-license'          => __( 'Activate License', 'intensely' ),
		'status-unknown'            => __( 'License status is unknown.', 'intensely' ),
		'renew'                     => __( 'Renew?', 'intensely' ),
		'unlimited'                 => __( 'unlimited', 'intensely' ),
		'license-key-is-active'     => __( 'License key is active.', 'intensely' ),
		'expires%s'                 => __( 'Expires %s.', 'intensely' ),
		'expires-never'             => __( 'Lifetime License.', 'intensely' ),
		'%1$s/%2$-sites'            => __( 'You have %1$s / %2$s sites activated.', 'intensely' ),
		'license-key-expired-%s'    => __( 'License key expired %s.', 'intensely' ),
		'license-key-expired'       => __( 'License key has expired.', 'intensely' ),
		'license-keys-do-not-match' => __( 'License keys do not match.', 'intensely' ),
		'license-is-inactive'       => __( 'License is inactive.', 'intensely' ),
		'license-key-is-disabled'   => __( 'License key is disabled.', 'intensely' ),
		'site-is-inactive'          => __( 'Site is inactive.', 'intensely' ),
		'license-status-unknown'    => __( 'License status is unknown.', 'intensely' ),
		'update-notice'             => __( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'intensely' ),
		'update-available'          => __('<strong>%1$s %2$s</strong> is available. <a href="%3$s" class="thickbox" title="%4s">Check out what\'s new</a> or <a href="%5$s"%6$s>update now</a>.', 'intensely' ),
	)

);