<?php
/*
 *	This template contains post single related posts
 *
 *	@version 1.0
 *	@since intensely 1.0
 */
?>
<?php 
	/*
	 *	Enable / Disable related posts
	 */
	 $related_posts	=	esc_html( get_theme_mod( 'intensely_blog_single_related_posts', '0' ) );
	 if( $related_posts == '0' ): ?>
	 
<?php
	/*
	 *	Related posts by category
	 *
	 *	@since intensely 1.0
	 */
	$categories = get_the_category( $post->ID );
	if ( $categories ) {

		$category_ids = array();
		foreach( $categories as $individual_category ) {
			$category_ids[] = $individual_category->term_id;
		}
	
		$args = array(
			'category__in' 			=> $category_ids,
			'post__not_in' 			=> array( $post->ID ),
			'posts_per_page'		=> 2, 
			'ignore_sticky_posts'	=> 1  
		);
	
		$related_posts_query = new WP_Query( $args );
		if( $related_posts_query->have_posts() ) {
			
			echo '<div class="il-related-post">
					<h3>'. __('You Might Also Like', 'intensely') .'</h3>
					<div class="il-retated-post-content">
						<div class="row">';
					
			while( $related_posts_query->have_posts() ) {		
				$related_posts_query->the_post(); ?>
				
				  	<div class="col-md-6 col-sm-6 col-xs-12">
						<article id="post-<?php the_ID(); ?>" <?php post_class( 'blog-news-single' ); ?>>
						    
						    <?php if( has_post_thumbnail() ): ?>
							    <div class="blog-news-img">
							      <a href="<?php esc_url( the_permalink() ); ?>">
								      <?php the_post_thumbnail( 'post-thumbnail', array( 'alt' => esc_attr( get_the_title() ) ) ); ?>
								  </a>
							    </div>
						    <?php endif; ?>
						    
						    <div class="blog-news-title">
							    <h2> <a href="<?php esc_url( the_permalink() ); ?>"><?php the_title(); ?></a> </h2>
								<?php get_template_part( 'post', 'meta' ); ?>
						    </div>
						    
						    <div class="blog-news-details">
								<p><?php echo intensely_custom_post_excerpt(); ?></p>
								<a class="blog-more-btn" href="<?php esc_url( the_permalink() ); ?>"><?php _e( 'Read More', 'intensely' ); ?> <i class="fa fa-long-arrow-right"></i></a>
						    </div>
						    
						</article>  
				  	</div>
					
<?php }
	echo '</div></div></div>';
		}
	}
	wp_reset_query(); ?>
	
<?php endif; ?>