 <?php
/*
 *	Contains testimonial slider contents
 *
 *	@version 1.0
 *	@intensely 1.0
 */
 ?>
 <?php
/*
 *	Enable/Disable testimonial section
 *
 *	@since intensely 1.0
 */
 $testimonial_section	=	esc_html( get_theme_mod( 'intensely_testimonials_enable_disable', '1' ) );
 if( $testimonial_section ): ?>
  	<section id="testimonial">
	    <div class="container">
		    <div class="row">
		        <div class="col-md-6">
		          <div class="row">
		            <div class="col-md-12">
		              <div class="title-area">
		                
		                <?php
			                $testimonial_section_title	=	esc_html( get_theme_mod( 'intensely_testimonials_title', '' ) );
			                if( $testimonial_section_title != '' ):
		                ?>
			                <h2 class="title"><?php echo $testimonial_section_title; ?></h2>
			                <span class="line"></span>
		                <?php endif; ?>
		                           
		              </div>
		            </div>
		            <div class="col-md-12">
		              <!-- Start testimonial slider -->
		              
					  	<?php
						
						$testimonials = get_theme_mod( 'intensely_testimonials_option', array() );
						
						if( $testimonials ){ ?>
						
							<div class="testimonial-slider">
							 
								<?php
								/*
								 *	Start pricing loop
								 */
								foreach ( $testimonials as $testimonial_item ) {
								
								/*
								 *	set counters variables
								 */
								$testimonial_image		=	wp_get_attachment_image_src( $testimonial_item['intensely_tm_image'], 'full' );
								$testimonial_image_alt	=	get_post_meta( $testimonial_item['intensely_tm_image'], '_wp_attachment_image_alt', true );
								$testimonial_desc		=	esc_textarea( $testimonial_item['intensely_tm_desc'] );
								$testimonial_name		=	esc_html( $testimonial_item['intensely_tm_name'] );
								$testimonial_position	=	esc_html( $testimonial_item['intensely_tm_position'] );
							?>

				                <!-- Start single slider -->
				                <div class="single-slider">
									<?php if( $testimonial_image ): ?>
						                  <div class="testimonial-img">
						                    <img src="<?php echo esc_url( $testimonial_image['0'] );?>" alt="<?php echo $testimonial_image_alt; ?>" />
						                  </div>
									<?php endif; ?>

				                  <div class="testimonial-content">
					                  
									<?php if( $testimonial_desc ): ?>
											<p><?php echo $testimonial_desc; ?></p>
									<?php endif; ?>
									
				                    <h6>
					                    <?php echo $testimonial_name; ?>, <?php if( $testimonial_position ): ?><span><?php echo $testimonial_position?></span><?php endif; ?></h6>
				                    
				                  </div>
				                </div>
		                
								<?php } ?>
								
		              		</div>
		              
					  	<?php } ?>
		              
		            </div>
		          </div>
		        </div>      
		    </div>
		</div>
	</section>
<?php endif; ?>