<?php
/*
 *	Contains team members content.
 *
 *	@version 1.0
 *	@since intensely 1.0
 */
?>
<?php
/*
 *	Enable / Disable team members section
 *
 *	@since intensely 1.0
 */
 $team_members_section	=	esc_html( get_theme_mod( 'intensely_team_members_enable_disable', '1' ) );
 if( $team_members_section ): ?>
	<!-- Start Pricing table -->
	<section id="our-team">
		<div class="container">
		  	<div class="row">
		        <div class="col-md-12">
			        <div class="title-area">
				        
				        <?php
					        /*
						     *	Team member section title
					         */
					         $team_member_section_title	=	esc_html( get_theme_mod( 'intensely_team_members_title', '' ) );
					         if( $team_member_section_title != '' ):
				        ?>
				            <h2 class="title"><?php echo $team_member_section_title; ?></h2>
				            <span class="line"></span>
			            <?php endif; ?>
			            
				        <?php
					        /*
						     *	Team member section description
					         */
					         $team_member_section_desc	=	esc_html( get_theme_mod( 'intensely_team_members_desc', '' ) );
					         if( $team_member_section_desc != '' ):
				        ?>
			            	<p><?php echo $team_member_section_desc; ?></p>
			            <?php endif; ?>
			            
			        </div>
			    </div>
			    <div class="col-md-12">
			        <div class="our-team-content">
			            <div class="row">
				            
						<!-- Start team members -->
						<?php
							
							$team_members = get_theme_mod( 'intensely_team_members_option', array() );
							
							if( $team_members ){
							
								/*
								 *	Start member loop
								 */
								foreach ( $team_members as $member ) {
								
								/*
								 *	set member variables
								 */
								$member_image		=	wp_get_attachment_image_src( $member['intensely_member_image'], 'full' );
								$member_image_alt	=	get_post_meta( $member['intensely_member_image'], '_wp_attachment_image_alt', true );
								$member_name		=	esc_html( $member['intensely_member_name'] );
								$member_position	=	esc_html( $member['intensely_member_position'] );	
								$member_desc		=	esc_textarea( $member['intensely_member_desc'] );
								$member_fb			=	esc_url( $member['intensely_member_facebook'] );
								$member_twitter		=	esc_url( $member['intensely_member_twitter'] );
								$member_linkedin	=	esc_url( $member['intensely_member_linkedin'] );
							?>
				            
				              	<!-- Start single team member -->
				              	<div class="col-md-3 col-sm-6 col-xs-12">
					                <div class="single-team-member">
						                <div class="team-member-img">
						                   <img src="<?php echo esc_url( $member_image['0'] ); ?>" alt="<?php echo esc_attr( $member_image_alt ); ?>">
						                </div>
						                <div class="team-member-name">
						   					<?php if ( $member_name ):?>
												<p><?php echo $member_name; ?></p>
											<?php endif;?>
											
						   					<?php if ( $member_position ):?>
												<span><?php echo $member_position; ?></span>
											<?php endif;?>
						                </div>
						                
					   					<?php if ( $member_desc ):?>
											<p><?php echo $member_desc; ?></p>
										<?php endif;?>
						                
						                <?php if( $member_fb || $member_twitter || $member_linkedin ) : ?>
							                <div class="team-member-link">
							   					<?php if ( $member_fb ):?>
													<a href="<?php echo $member_fb; ?>"><i class="fa fa-facebook" aria-hidden="true"></i></a>
												<?php endif;?>
												
							   					<?php if ( $member_twitter ):?>
													<a href="<?php echo $member_twitter; ?>"><i class="fa fa-twitter" aria-hidden="true"></i></a>
												<?php endif;?>
												
							   					<?php if ( $member_linkedin ):?>
													<a href="<?php echo $member_linkedin; ?>"><i class="fa fa-linkedin" aria-hidden="true"></i></a>
												<?php endif;?>
												
							                </div>
						                <?php endif; ?>
						                
					                </div>
								</div>
								<!-- Start single team member -->
							
								<?php } ?>
							<?php } ?>
			              
			            </div>
			        </div>
		        </div>
		    </div>
		</div>
	</section>
<?php endif; ?>