<?php
/*
 *	Contains service items content.
 *
 *	@version 1.0
 *	@since intensely 1.0
 */
?>
<?php
/*
 *	Enable / Disable services section
 *
 *	@since intensely 1.0
 */
 $service_section	=	esc_html( get_theme_mod( 'intensely_services_enable_disable', '1' ) );
 if( $service_section ): ?>
 
		<section id="service">
			<div class="container">
			    <div class="row">
				    
			        <div class="col-md-12">
			          	<div class="title-area">
				            
				            <?php
					            /*
						         *	services section title
					             */
					             $service_section_title	=	esc_html( get_theme_mod( 'intensely_services_title', '' ) );
					             if( $service_section_title != '' ): ?>
						            <h2 class="title"><?php echo $service_section_title; ?></h2>
						            <span class="line"></span>
				            <?php endif; ?>
				            
				            <?php
					            /*
						         *	services section description
					             */
					             $service_section_desc	=	esc_textarea( get_theme_mod( 'intensely_services_desc', '' ) );
					             if( $service_section_desc != '' ): ?>
						            <p><?php echo $service_section_desc; ?></p>
				            <?php endif; ?>
				            
						</div>
			        </div>
			        
			        <div class="col-md-12">
				        <div class="service-content">
				            <div class="row">
					            
							<!-- Start services -->
							<?php
								
								$services = get_theme_mod( 'intensely_services_option', array() );
								
								if( $services ){
								
									/*
									 *	Start counter loop
									 */
									foreach ( $services as $service_item ) {
									
									/*
									 *	set counters variables
									 */
									$service_icon		=	esc_html( $service_item['intensely_service_icon'] );		// counter icon
									$service_title		=	esc_html( $service_item['intensely_service_title'] );		// counter number
									$service_desc		=	esc_textarea( $service_item['intensely_service_desc'] );	// counter text
								?>
					            
							            <!-- Start single service -->
							            <div class="col-md-4 col-sm-6">
							                <div class="single-service">
							                  <i class="fa <?php echo $service_icon; ?> service-icon"></i>
							                  <h4 class="service-title"><?php echo $service_title; ?></h4>
							                  <p><?php echo $service_desc; ?></p>
							                </div>
							            </div>
							            <!-- End single service -->
					            
									<?php } ?>
					            <?php } ?>
					            
				            </div>
				        </div>
			        </div>
			        
			        
			    </div>
			</div>
		</section>
		
<?php endif; ?>