<?php
/*
 *	Contains pricing tables content.
 *
 *	@version 1.0
 *	@since intensely 1.0
 */
?>
<?php
/*
 *	Enable / Disable pricing table section
 *
 *	@since intensely 1.0
 */
 $pricing_table_section	=	esc_html( get_theme_mod( 'intensely_pricing_enable_disable', '1' ) );
 if( $pricing_table_section ): ?>
	<section id="pricing-table">
		<div class="container">
		    <div class="row">
		        
		        <div class="col-md-12">
			        <div class="title-area">
				    	
				    	<?php 
					    	/*
						     *	Pricing table section title
					    	 */
					    	 $pricing_table_section_title	=	esc_html( get_theme_mod( 'intensely_pricing_title', '' ) );
					    	 if( $pricing_table_section_title != '' ):
				    	?>    
					            <h2 class="title"><?php echo $pricing_table_section_title; ?></h2>
					            <span class="line"></span>
			            <?php endif; ?>
			            
				    	<?php 
					    	/*
						     *	Pricing table section description
					    	 */
					    	 $pricing_table_section_desc	=	esc_html( get_theme_mod( 'intensely_pricing_desc', '' ) );
					    	 if( $pricing_table_section_desc != '' ):
				    	?>    
			            	 <p><?php echo $pricing_table_section_desc; ?></p>
			            <?php endif; ?>
			            
			        
			        </div>
		        </div>
					
				<div class="col-md-12">
					<div class="pricing-table-content">
						<div class="row">
							
							<!-- Pricing tables -->
							<?php
								
								$pricing_tables = get_theme_mod( 'intensely_pricing_option', array() );
								
								if( $pricing_tables ){
								
									/*
									 *	Start pricing loop
									 */
									foreach ( $pricing_tables as $table ) {
									
									/*
									 *	set counters variables
									 */
									$table_title		=	esc_html( $table['intensely_pricing_table_title'] );
									$table_price		=	esc_html( $table['intensely_pricing_table_price'] );
									$table_currency		=	esc_html( $table['intensely_pricing_table_currency'] );
									$table_payroll		=	esc_html( $table['intensely_pricing_table_payroll'] );
									
									$table_feature_1	=	esc_html( $table['intensely_pricing_table_feature_1'] );
									$table_feature_2	=	esc_html( $table['intensely_pricing_table_feature_2'] );
									$table_feature_3	=	esc_html( $table['intensely_pricing_table_feature_3'] );
									$table_feature_4	=	esc_html( $table['intensely_pricing_table_feature_4'] );
									$table_feature_5	=	esc_html( $table['intensely_pricing_table_feature_5'] );
									$table_feature_6	=	esc_html( $table['intensely_pricing_table_feature_6'] );
									$table_feature_7	=	esc_html( $table['intensely_pricing_table_feature_7'] );
									$table_feature_8	=	esc_html( $table['intensely_pricing_table_feature_8'] );
									$table_feature_9	=	esc_html( $table['intensely_pricing_table_feature_9'] );
									$table_feature_10	=	esc_html( $table['intensely_pricing_table_feature_10'] );
									$table_feature_10	=	esc_html( $table['intensely_pricing_table_feature_10'] );
									
									$table_button_text			=	esc_html( $table['intensely_pricing_table_button_text'] );
									$table_button_url			=	esc_url( $table['intensely_pricing_table_button_url'] );
									$table_button_target_value	=	esc_html( $table['intensely_pricing_table_button_target'] );
									$table_button_target		=	( $table_button_target_value )? '_blank' : '_self';
									
									$table_featured_value	=	esc_html( $table['intensely_pricing_table_featured'] );
									$table_featured			=	( $table_featured_value ) ? 'featured-price' : '';
								?>		
										<div class="col-md-3 col-sm-6 col-xs-12">
							                <div class="single-table-price <?php echo $table_featured; ?>">
								                <div class="price-header">
								                    <span class="price-title"><?php echo $table_title; ?></span>
								                    <div class="price">
								                      <sup class="price-up"><?php echo $table_currency; ?></sup>
								                      <?php echo $table_price; ?>
								                      <span class="price-down">/<?php echo $table_payroll; ?></span>
								                    </div>
								                </div>
								                <div class="price-article">
								                    <ul>
									                  <?php if( $table_feature_1 != '' ): ?>
								                      	<li><?php echo $table_feature_1; ?></li>
								                      <?php endif; ?>
								                      
									                  <?php if( $table_feature_2 != '' ): ?>
								                      	<li><?php echo $table_feature_2; ?></li>
								                      <?php endif; ?>
								                      
									                  <?php if( $table_feature_3 != '' ): ?>
								                      	<li><?php echo $table_feature_3; ?></li>
								                      <?php endif; ?>
								                      
									                  <?php if( $table_feature_4 != '' ): ?>
								                      	<li><?php echo $table_feature_4; ?></li>
								                      <?php endif; ?>
								                      
									                  <?php if( $table_feature_5 != '' ): ?>
								                      	<li><?php echo $table_feature_5; ?></li>
								                      <?php endif; ?>
								                      
									                  <?php if( $table_feature_6 != '' ): ?>
								                      	<li><?php echo $table_feature_6; ?></li>
								                      <?php endif; ?>
								                      
									                  <?php if( $table_feature_7 != '' ): ?>
								                      	<li><?php echo $table_feature_7; ?></li>
								                      <?php endif; ?>
								                      
									                  <?php if( $table_feature_8 != '' ): ?>
								                      	<li><?php echo $table_feature_8; ?></li>
								                      <?php endif; ?>
								                      
									                  <?php if( $table_feature_9 != '' ): ?>
								                      	<li><?php echo $table_feature_9; ?></li>
								                      <?php endif; ?>
								                      
									                  <?php if( $table_feature_10 != '' ): ?>
								                      	<li><?php echo $table_feature_10; ?></li>
								                      <?php endif; ?>
								                      
								                    </ul>
								                  </div>
								                  
								                  <?php if( $table_button_text && $table_button_url ): ?>
								                  	<div class="price-footer">
								                    	<a class="purchase-btn" href="<?php echo $table_button_url; ?>" target="<?php echo $table_button_target; ?>"><?php echo $table_button_text; ?></a>
								                	</div>
												  <?php endif; ?>
								                
							                </div>
										</div>
								<?php } ?>
							<?php } ?>
							
							
			            </div>
			        </div>
		        </div>
		    </div>
		</div>
	</section>
	<!-- End Pricing table -->  
<?php endif; ?>