<?php
/*
 *	Contains portfolio items contents.
 *
 *	@version 1.0
 *	@since intensely 1.0
 */
?>
<?php
/*
 *	Enable/disable portfolio section
 *
 *	@since intensely 1.0
 */
 $portfolio_section	=	esc_html( get_theme_mod( 'intensely_portfolio_enable_disable', '1' ) );
 if( $portfolio_section ): ?>
   	<section id="portfolio">
	   <div class="container">
		   <div class="row">
			   
			   <div class="col-md-12">
					<div class="title-area">
			            <?php
				            /*
					         *	Portfolio title
				             */
				             $portfolio_section_title	=	esc_html( get_theme_mod( 'intensely_portfolio_title', '' ) );
				             if( $portfolio_section_title != '' ): ?>
					            <h2 class="title"><?php echo $portfolio_section_title; ?></h2>
					            <span class="line"></span>
			            <?php endif; ?>
			            
			            <?php
				            /*
					         *	Portfolio description
				             */
				             $portfolio_section_desc	=	esc_textarea( get_theme_mod( 'intensely_portfolio_desc', '' ) );
				             if( $portfolio_section_desc != '' ): ?>
					            <p><?php echo $portfolio_section_desc; ?></p>
			            <?php endif; ?>
			            
			        </div>
				</div>
			   
			   <div class="col-md-12">
				    <div class="portfolio-area home-portfolio intensely-custom-template">     
				       	<!-- Portfolio container -->
				       	<div class="portfolio-container">
					       	
							<?php
								/*
								 *	Set vars for portfolio post type query
								 *
								 *	@intensely 1.0
								 */
								$portfolio_count			=	esc_html( get_theme_mod( 'intensely_portfolio_display_count', 4 ) );
								$portfolio_display_order	=	esc_html( get_theme_mod( 'intensely_portfolio_display_order', 'DESC' ) );
								
								$portfolio_args = array( 
									'post_type' 			=> 'intensely-portfolio', 
									'posts_per_page' 		=> $portfolio_count,
									'ignore_sticky_posts'	=> 1,
									'order'     			=> $portfolio_display_order, //DESC - ASC
								);	

								$portfolio_loop = new WP_Query( $portfolio_args );
									
								if ( $portfolio_loop -> have_posts() ) :	
									while ( $portfolio_loop->have_posts() ) : $portfolio_loop->the_post(); ?>
								    
								        <div class="single-portfolio"> 
								           	<div class="single-item">
								             	<?php the_post_thumbnail( 'intensely-portfolio-thumb', array( 'alt' => esc_attr( get_the_title() ) ) ); ?>
									            <div class="single-item-content">               
										            <a class="view-icon" href="#"><i class="fa fa-search-plus"></i></a>
													<div class="portfolio-title">
										                <?php the_title( '<h4>', '</h4>' );?>
														<?php display_portfolio_taxonomy_terms('intensely-portfolio-taxonomy'); ?>
													</div>
										           	<div class="portfolio-detail">
									                    <a href="#" class="modal-close-btn"><span class="fa fa-times"></span></a>
									                    <?php the_post_thumbnail( 'intensely-portfolio-thumb', array( 'alt' => esc_attr( get_the_title() ) ) ); ?>
									                    <?php the_title( '<h4>', '</h4>' );?>
									                    <?php the_content(); ?>
														<?php									                    
															/*
															 *  Portfolio Meta
															 *	set variables
															 *
															 *	@since intensely 1.0
															 */
															$button_text 			= esc_html( get_post_meta( get_the_ID(), '_intensely_portfolio_demo_btn_text', true ) );
															$button_url 			= esc_url( get_post_meta( get_the_ID(), '_intensely_portfolio_demo_btn_url', true ) );
															$button_target_value 	= esc_html( get_post_meta( get_the_ID(), '_intensely_portfolio_demo_btn_target', true ) );
															$button_target			= ( $button_target_value ) ? '_blank' : '_self' ;
														?>
									                    
									                    <?php if( $button_text && $button_url ): ?>
									                    	<a href="<?php echo $button_url; ?>" class="view-project-btn" target="<?php echo $button_target;?>"><?php echo $button_text; ?></a>
									                    <?php endif; ?>
									                    
										            </div>
												</div>
											</div>
									    </div>								
						
							<?php
								    endwhile;
								endif;
								wp_reset_postdata(); 
							?>
						         
						</div>        
				    </div>
			   </div>
			   
			   
			   
		   </div>
	   </div>
	</section>
<?php endif; ?>