 <?php
/*
 *	Contains numeric counter contents
 *
 *	@version 1.0
 *	@since intensely 1.0
 */
 ?>
<?php
/*
 *	Enable / disable counter section
 *
 *	@since intensely 1.0
 */
 $counter_section	=	esc_html( get_theme_mod( 'intensely_counter_enable_disable', '1' ) );
 if( $counter_section == '1' ) : ?>
 
	<section id="counter">
		<div class="counter-overlay">
		  <div class="container">
		        <div class="row">
			        <div class="col-md-12">
			            <div class="counter-area">
				            <div class="row">
					            
							<!-- Start Counters -->
							<?php
								
								$counters = get_theme_mod( 'intensely_counter_option', array() );
								
								if( $counters ){
								
									/*
									 *	Start counter loop
									 */
									foreach ( $counters as $counter_item ) {
									
									/*
									 *	set counters variables
									 */
									$counter_icon		=	esc_html( $counter_item['intensely_counter_icon'] );	// counter icon
									$counter_number		=	esc_html( $counter_item['intensely_counter_number'] );	// counter number
									$counter_text		=	esc_html( $counter_item['intensely_counter_text'] );	// counter text
								?>
					            
						                <!-- Start single counter -->
						                <div class="col-md-3 col-sm-6">
							                <div class="single-counter">
												<?php if ( $counter_icon ):?>
								                    <div class="counter-icon">
								                      <i class="fa <?php echo $counter_icon; ?>"></i>
								                    </div>
												<?php endif;?>
							                    
												<?php if ( $counter_number ):?>
								                    <div class="counter-no counter">
								                      <?php echo $counter_number; ?>
								                    </div>
												<?php endif;?>
							                    
												<?php if ( $counter_text ):?>
								                    <div class="counter-label">
								                      <?php echo $counter_text; ?>
								                    </div>
												<?php endif;?>
							                    
							                </div>
						                </div>
						                <!-- End single counter -->
				                
				                	<?php } ?>
				                <?php } ?>
				                
				            </div>
				        </div>
			        </div>
		        </div>
			</div>
		</div>
	</section>
	
<?php endif; ?>