 <?php
/*
 *	Contains front-page main slider contents
 *
 *	@version 1.0
 *	@since intensely 1.0
 */
 ?>
 <?php
/*
 *	Slider enable/disable
 *
 *	@since intensely 1.0
 */
 $featured_slider_enable	=	get_theme_mod( 'intensely_featured_slider', '1' );
 if( $featured_slider_enable ) : ?>
 
  	<section id="slider">
	    <div class="main-slider">
		    
			<?php
				$featured_slider	=	get_theme_mod( 'intensely_slide_option', array() );
				/*
				 *	Start slider loop
				 *
				 *	@since intensely 1.0
				 */
				foreach ( $featured_slider as $slides ) {
				
				/*
				 *	set slide variables
				 *
				 *	@since intensely 1.0
				 */
				$slide_bg_image		=	wp_get_attachment_image_src( $slides['intensely_slide_bg_image'], 'full' );
				$slide_bg_image_alt	=	get_post_meta( $slides['intensely_slide_bg_image'], '_wp_attachment_image_alt', true );
				
				$slide_image		=	wp_get_attachment_image_src( $slides['intensely_slide_image'], 'full' );
				$slide_image_alt	=	get_post_meta( $slides['intensely_slide_image'], '_wp_attachment_image_alt', true );	
				
				$slide_title		=	esc_html( $slides['intensely_slide_text'] );											
				$slide_short_desc	=	esc_textarea( $slides['intensely_slide_short_desc'] );
				$slide_button_text	=	esc_html( $slides['intensely_slide_button_text'] );
				$slide_button_link	=	esc_url( $slides['intensely_slide_button_link'] );									
				$slide_link_target	=	esc_html( $slides['intensely_slide_button_target'] );
			?>
			    
			    <div class="single-slide">
				    
					<?php if( $slide_bg_image ): ?>
						<img src="<?php echo esc_url( $slide_bg_image['0'] );?>" alt="<?php echo $slide_bg_image_alt; ?>" />
					<?php endif; ?>
			        
			        <div class="slide-content">
			          	<div class="container">
			            	<div class="row">
				              <div class="col-md-6 col-sm-6">
				                <div class="slide-article">
					                
					                <!-- slide title -->
									<?php if ( $slide_title ):?>
										<h2> <?php echo $slide_title; ?> </h2>
									<?php endif;?>
									
									<!-- slide short description-->
									<?php if ( $slide_short_desc ):?>
										<p> <?php echo $slide_short_desc; ?> </p>
									<?php endif;?>
									
									<!-- slide button -->
									<?php if( $slide_button_link && $slide_button_text ): ?>
										<?php $slide_button_link_target	=	( $slide_link_target ) ? '_blank' : '_self'; // button target ?>
										<a class="read-more-btn" href="<?php echo $slide_button_link; ?>" target="<?php echo $slide_button_link_target; ?>" >
											<?php echo $slide_button_text; ?>
										</a>
									<?php endif;?>
									
				                </div>
				              </div>
				              
				              <div class="col-md-6 col-sm-6">
								<?php if( $slide_image ): ?>
					                <div class="slider-img">      
					                	<img src="<?php echo esc_url( $slide_image['0'] );?>" alt="<?php echo $slide_image_alt; ?>" />
					                </div>
								<?php endif; ?>
				              </div>
				              
			            	</div>
			          	</div>
			        </div>
			    </div>
		    
		    <?php }	?>
		              
	    </div>
  	</section>
  	
<?php endif; ?>