<?php
/*
 *	Contains blog posts content
 *
 *	@version 1.0
 *	@since intensely 1.0
 */
?>
<?php
/*
 *	Enable / Disable blog posts section
 *
 *	@intensely 1.0
 */
 $blog_posts_section	=	esc_html( get_theme_mod( 'intensely_home_blog_enable_disable', '1' ) );
 if( $blog_posts_section ): ?>
	<section id="latest-news">
	    <div class="container">
		    <div class="row">
		        <div class="col-md-12">
			       
			        <div class="title-area">
				        <?php
					        $blog_posts_section_title	=	esc_html( get_theme_mod( 'intensely_home_blog_title', '' ) );
					        if( $blog_posts_section_title != '' ):
				        ?>
					            <h2 class="title"><?php echo $blog_posts_section_title; ?></h2>
					            <span class="line"></span>
				        <?php endif; ?>
		        
		        
				        <?php
					        $blog_posts_section_desc	=	esc_html( get_theme_mod( 'intensely_home_blog_desc', '' ) );
					        if( $blog_posts_section_desc != '' ):
				        ?>
							<p><?php echo $blog_posts_section_desc; ?></p>
				        <?php endif; ?>
			            
			        </div>
			        
		        </div>
		        <div class="col-md-12">
			        
				<!-- Start blog posts -->
				<?php
					$home_blog_post_count		=	esc_html( get_theme_mod( 'intensely_home_blog_post_count', '3' ) );
					$home_posts_display_order	=	esc_html( get_theme_mod( 'intensely_home_posts_display_order', 'DESC' ) );
					
					$home_blog_args = array( 
						'post_type' 			=> 'post', 
						'posts_per_page' 		=> $home_blog_post_count,
						'ignore_sticky_posts'	=> 1,
						'order'     			=> $home_posts_display_order, //DESC - ASC
					);	

					$home_blog_loop = new WP_Query( $home_blog_args );
						
					if ( $home_blog_loop -> have_posts() ) :	?>
			        
				        <div class="latest-news-content">
				            <div class="row">
					            
								<!-- Start blog posts loop -->
								<?php while ( $home_blog_loop->have_posts() ) : $home_blog_loop->the_post(); ?>
					            
				              	<!-- start single latest news -->
				              	<div class="col-md-4">
					                <article id="post-<?php the_ID(); ?>" <?php post_class( 'blog-news-single' ); ?>>
						                
						                <?php if( has_post_thumbnail() ): ?>
							                <div class="blog-news-img">
							                    <a href="<?php esc_url( the_permalink() ); ?>">
													<?php the_post_thumbnail( 'post-thumbnail', array( 'alt' => esc_attr( get_the_title() ) ) ); ?>
								                </a>
							                </div>
						                <?php endif; ?>
									    
									    <div class="blog-news-title">
										    <h2> <a href="<?php esc_url( the_permalink() ); ?>"><?php the_title(); ?></a> </h2>
											<?php get_template_part( 'post', 'meta' ); ?>
									    </div>
									    
						                <div class="blog-news-details">
						                    <p><?php echo intensely_custom_post_excerpt(); ?></p>
						                    <a class="blog-more-btn" href="<?php esc_url( the_permalink() ); ?>"><?php _e( 'Read More', 'intensely' ); ?> <i class="fa fa-long-arrow-right"></i></a>
						                </div>
					                </article>
								</div>
								
								<?php endwhile; ?>
								<!-- End blog posts loop -->
				              	
				              	
				            </div>
				        </div>
			        
					<?php	
						endif;
						wp_reset_postdata(); ?>	
			        
		        </div>
			</div>
		</div>
	</section>
<?php endif; ?>