<?php
/*
 *	Contains front-page about us section content.
 *
 *	@version 1.0
 *	@since intensely 1.0
 */
?>
<?php
/*
 *	About section enable/disable
 *
 *	@since intensely 1.0
 */
 $about_section	=	esc_html( get_theme_mod( 'intensely_about_enable_disable', '1' ) );
 if( $about_section ) : ?>
	<section id="about">
		<div class="container">
		    <div class="row">
		        
		        <!-- Start section title & description -->
		        <div class="col-md-12">
			        <div class="title-area">
		                <!-- title -->
						<?php 
							$about_section_title	=	esc_html( get_theme_mod( 'intensely_about_title', '' ) );
							if ( $about_section_title ):?>
							<h2 class="title"> <?php echo $about_section_title; ?> </h2>
						<?php endif;?>
			            <span class="line"></span>
		                
		                <!-- Description -->
						<?php 
							$about_section_desc	=	esc_html( get_theme_mod( 'intensely_about_desc', '' ) );
							if ( $about_section_desc ):?>
							<p> <?php echo $about_section_desc; ?> </p>
						<?php endif;?>
			            
			        </div>
		        </div>
		        <!-- End section title & description -->
		        		        
		        <div class="col-md-12">
			        <div class="about-content">
			            <div class="row">
			              	
			             	<!-- Start progress bar section -->
			             	<?php
				             	/*
					             *	Enable/disable skills
					             *
					             *	@since intensely 1.0
				             	 */
				             	$skill_section	=	esc_html( get_theme_mod( 'intensely_about_skill', '0' ) );
				             	 if( $skill_section == '0' ): ?>
					              	<div class="col-md-6">
					                	<div class="our-skill">
						                  
							                <!-- Progress bar title -->
											<?php 
												$about_progressbar_title	=	esc_html( get_theme_mod( 'intensely_about_progressbar_title', '' ) );
												if ( $about_progressbar_title ):?>
												<h3> <?php echo $about_progressbar_title; ?> </h3>
											<?php endif;?>                 
						                  	
						                  	<div class="our-skill-content">
							                  	
								                <!-- Progress bar description -->
												<?php 
													$about_progressbar_desc	=	esc_html( get_theme_mod( 'intensely_about_progressbar_desc', '' ) );
													if ( $about_progressbar_desc ):?>
													<p> <?php echo $about_progressbar_desc; ?> </p>
												<?php endif;?> 
												
							                    <?php
								                    $progress_bars	=	get_theme_mod( 'intensely_about_progressbar_option', array() );
													/*
													 *	Start loop
													 *
													 *	@since intensely 1.0
													 */
													foreach ( $progress_bars as $bars ) {
														$bar_text		=	esc_html( $bars['intensely_progressbar_name'] );
														$bar_limit		=	esc_html( $bars['intensely_progressbar_value'] );
							                    ?>
								                    <div class="progress">
									                    <div class="progress-bar six-sec-ease-in-out" role="progressbar" data-transitiongoal="<?php echo $bar_limit; ?>">
									                        <span class="progress-title"><?php echo $bar_text; ?></span>
									                    </div>
								                  	</div>
								                  	
							                  	<?php } ?>
							                  	
					                  			</div>  
					                  	                
					                		</div>
					              	</div>
					            <?php endif; ?>  	
			              	<!-- End progress bar section -->
			              	
			              	<!-- Start accordion section -->
			             	<?php
				             	/*
					             *	Enable/disable accordions
					             *
					             *	@since intensely 1.0
				             	 */
				             	$accordion_section	=	esc_html( get_theme_mod( 'intensely_about_accordion', '0' ) );
				             	 if( $accordion_section == '0' ): ?>
								  	<div class="col-md-6">
					                	<div class="why-choose-us">
							                
							                <!-- Accordion title -->
											<?php 
												$about_accordion_title	=	esc_html( get_theme_mod( 'intensely_about_accordion_title', '' ) );
												if ( $about_accordion_title ):?>
												<h3> <?php echo $about_accordion_title; ?> </h3>
											<?php endif;?>
							                
											<!-- Start accordion -->
											<?php
												/*
												 *	Get accordion
												 */
												$accordions = get_theme_mod( 'intensely_about_accordion_option', array() );
																					
												if( $accordions ){	?>
													
													<!-- Accordion container -->
									                <div class="panel-group why-choose-group" id="accordion">
									                    
														<?php
														
															/*
															 *	Start accordion loop
															 *
															 *	@since intensely 1.0
															 */
															 
															$count	= 1; 
															foreach ( $accordions as $accordion_item ) {
															
															/*
															 *	set accordion variables
															 */
															// title & description
															$accordion_title	=	esc_html( $accordion_item['intensely_accordion_title'] );
															$accordion_desc		=	esc_textarea( $accordion_item['intensely_accordion_desc'] );
															
															// set accordion id
															if( $count == 1 ):
								                                $accordion_num	= 'One';								                                
								                            elseif( $count == 2 ) :
								                                $accordion_num = 'Two';
								                            elseif( $count == 3 ) :
								                                $accordion_num = 'Three';  
								                            elseif( $count == 4 ) :
								                                $accordion_num = 'Four';
								                            elseif( $count == 5 ) :
								                            	$accordion_num = 'Five';
								                            elseif( $count == 6 ) :
								                            	$accordion_num = 'Six';
								                            elseif( $count == 7 ) :
								                            	$accordion_num = 'Seven';
								                            elseif( $count == 8 ) :
								                            	$accordion_num = 'Eight';
								                            elseif( $count == 9 ) :
								                            	$accordion_num = 'Nine';
								                            elseif( $count == 10 ) :
								                            	$accordion_num = 'Ten';
								                            else : 
								                            	$accordion_num = '';
								                            endif;
								                            
								                            /*
									                         *	If it's the first one (accordion) then go ahead & store first
									                         *  expanded accordion classes, else put the global one.
								                             */ 
								                            if( $count === 1 ){
									                            $expanded_tab		= 'in';
									                            $expand_tab_icon	= 'fa-minus-square';
								                            }else{
									                            $expanded_tab		= '';
									                            $expand_tab_icon	= 'fa fa-plus-square';									                            
								                            }
			
														?>
															<!-- start accordion item -->
										                    <div class="panel panel-default">
											                    
											                    <?php if( $accordion_title ): ?>
												                    <div class="panel-heading">
												                        <h4 class="panel-title">
												                          <a data-toggle="collapse" data-parent="#accordion" href="#collapse<?php echo $accordion_num;?>">
												                            <?php echo $accordion_title; ?> <span class="fa <?php echo $expand_tab_icon; ?>"></span>
												                          </a>
												                        </h4>
												                    </div>
											                    <?php endif; ?>
											                     
											                     <?php if( $accordion_desc ): ?> 
												                    <div id="collapse<?php echo $accordion_num;?>" class="panel-collapse collapse <?php echo $expanded_tab; ?>">
												                        <div class="panel-body">
												                         	<p> <?php echo $accordion_desc; ?> </p>
												                        </div>
												                    </div>
											                    <?php endif; ?>
											                    
										                    </div>
										                    <!-- End accordion item -->
										                    
										                    <?php $count++;?>
										                <?php } ?>
									                    
									                </div>
							                
							                <?php } ?>
							                
										</div>
									</div>
								<?php endif; ?>   
						  	<!-- End accordion section -->
						  	
						  	
			            </div>
			        </div>
		        </div>
		        
		    </div>
		</div>
	</section>
<?php endif; ?>