<?php
/*
 *	This template contains single post author bio template
 *
 *	@version 1.0
 *	@since intensely 1.0
 */
?>
<?php 
	/*
	 *	Enable / Disable post author bio
	 */
	 $post_author_bio	=	esc_html( get_theme_mod( 'intensely_blog_single_author_bio', '0' ) );
	 if( $post_author_bio == '0' ): ?>
	 
		<!-- Start author bio -->
		<div class="il-author-bio">
			<div class="media">
			    
			    <div class="media-left">
			        <?php echo get_avatar( get_the_author_meta( 'ID' ), 100 ); ?>
			    </div>
			    
			    <div class="media-body">
			       <h4 class="il-author-msg"><?php _e( 'Written By', 'intensely' ); ?></h4>
			       <span class="il-author-title"><?php the_author(); ?></span>
			       <p><?php the_author_meta('description');?></p>
			       	<ul class="il-author-social">
			           	<?php if( get_the_author_meta('facebook') !== '' ): //facebook ?>
							<li><a href="<?php esc_url( the_author_meta('facebook') );?>" target="_blank"><i class="fa fa-facebook" aria-hidden="true"></i></a></li>
						<?php endif; ?>
						
						<?php if( get_the_author_meta('twitter') ): // twitter ?>
							<li><a href="https://twitter.com/<?php esc_html( the_author_meta('twitter') );?>"><i class="fa fa-twitter" aria-hidden="true"></i></a></li>
						<?php endif; ?>
						
						<?php if( get_the_author_meta('googleplus') !== '' ) : ?>
							<li><a href="<?php esc_url( the_author_meta('googleplus') );?>"><i class="fa fa-google-plus" aria-hidden="true"></i></a></li>
						<?php endif; ?>
						
						<?php if( get_the_author_meta('url') ): // url ?>
							<li><a href="<?php esc_url( the_author_meta('url') );?>"><i class="fa fa-external-link" aria-hidden="true"></i></a></li>
						<?php endif; ?>
					</ul>
			       
			    </div>
			</div>
		</div>
<?php endif; ?>