<?php
/*
 *	Registers intensely theme custom post types
 *
 *	@version 1.0
 *	@since intensely 1.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! function_exists( 'intensely_theme_post_types' ) ){

	function intensely_theme_post_types() {

		/*
		 *	Portfolio post type lebels
		 */
		$intensely_portfolio_labels = array(
			'name' 					=> __( 'Portfolios', 'intensely' ),
			'singular_name' 		=> __( 'Portfolio', 'intensely' ),
			'add_new' 				=> __( 'Add Portfolio', 'intensely' ),
			'add_new_item' 			=> __( 'Add New Portfolio', 'intensely' ),
			'edit_item' 			=> __( 'Edit Portfolio', 'intensely' ),
			'new_item' 				=> __( 'New Portfolio', 'intensely' ),
			'view_item' 			=> __( 'View Portfolio', 'intensely' ),
			'search_items' 			=> __( 'Search Portfolio', 'intensely' ),
			'not_found' 			=> __( 'No Portfolio found', 'intensely' ),
			'not_found_in_trash' 	=> __( 'No Portfolio found in Trash', 'intensely' ),
			'parent_item_colon' 	=> __( 'Parent Portfolio', 'intensely' ),
			'menu_name' 			=> __( 'Portfolios', 'intensely' ),
		);

		/*
		 *	Portfolio post type args
		 */
		$intensely_portfolio_args 	= array(
			'labels' 				=> $intensely_portfolio_labels,
			'hierarchical' 			=> false,
			'description' 			=> __( 'Portfolio post type', 'intensely' ),
			'supports' 				=> array( 'title', 'editor', 'thumbnail' ) ,
			'public' 				=> true,
			'show_ui' 				=> true,
			'show_in_menu' 			=> true,
			'menu_icon' 			=> 'dashicons-grid-view',
			'show_in_nav_menus' 	=> true,
			'publicly_queryable' 	=> true,
			'exclude_from_search' 	=> false,
			'has_archive' 			=> false,
			'query_var' 			=> true,
			'can_export' 			=> true,
			'rewrite' 				=> true,
			'capability_type' 		=> 'post',
		);
		/*
		 *	Register portfolio post type
		 *
		 *	@since intensely 1.0
		 */
		register_post_type( 'intensely-portfolio', $intensely_portfolio_args );		

	}
	add_action( 'init', 'intensely_theme_post_types' );
	
	/*
	 *	Register portfolio taxonomy
	 *
	 *	@intensely 1.0
	 */
	function intensely_portfolio_taxonomy() {
	
		$labels = array(
			'name'                       => _x( 'Project Types', 'Project Type', 'intensely' ),
			'singular_name'              => _x( 'Project Type', 'Project Type', 'intensely' ),
			'menu_name'                  => __( 'Project Types', 'intensely' ),
			'all_items'                  => __( 'All Items', 'intensely' ),
			'parent_item'                => __( 'Parent Item', 'intensely' ),
			'parent_item_colon'          => __( 'Parent Item:', 'intensely' ),
			'new_item_name'              => __( 'New Item Name', 'intensely' ),
			'add_new_item'               => __( 'Add New Item', 'intensely' ),
			'edit_item'                  => __( 'Edit Item', 'intensely' ),
			'update_item'                => __( 'Update Item', 'intensely' ),
			'view_item'                  => __( 'View Item', 'intensely' ),
			'separate_items_with_commas' => __( 'Separate items with commas', 'intensely' ),
			'add_or_remove_items'        => __( 'Add or remove items', 'intensely' ),
			'choose_from_most_used'      => __( 'Choose from the most used', 'intensely' ),
			'popular_items'              => __( 'Popular Items', 'intensely' ),
			'search_items'               => __( 'Search Items', 'intensely' ),
			'not_found'                  => __( 'Not Found', 'intensely' ),
			'no_terms'                   => __( 'No items', 'intensely' ),
			'items_list'                 => __( 'Items list', 'intensely' ),
			'items_list_navigation'      => __( 'Items list navigation', 'intensely' ),
		);
		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => true,
		);
		register_taxonomy( 'intensely-portfolio-taxonomy', array( 'intensely-portfolio' ), $args );
	
	}
	add_action( 'init', 'intensely_portfolio_taxonomy', 0 );

}