<?php
/*
 *  Add various theme necessary functions.
 *
 *	@version 1.0
 *	@since intensely 1.0
 */

/*
 *	Add classes to author avatar img tag
 *
 *	@since intensely 1.0
 */
function intensely_add_gravatar_class($class) {
    $class = str_replace("class='avatar", "class='avatar media-object author-img news-img", $class);
    return $class;
}
add_filter('get_avatar','intensely_add_gravatar_class');

/*
 *	Display portfolio taxonomy term name
 *
 *	@since intensely 1.0
 */
function display_portfolio_taxonomy_terms($post_type, $display = false) {
	global $post;
	$term_list = wp_get_post_terms($post->ID, $post_type, array('fields' => 'names'));
	
	if($display == false) {
	    echo $term_list[0];
	}elseif($display == 'return') {
	    return  $term_list[0];
	}
}

/**
 *  set custom post exceprt length
 *
 *  @since intensely 1.0
 */
 function intensely_custom_post_excerpt(){
	global $post;
	$excerpt = get_the_content();
	$excerpt = preg_replace(" (\[.*?\])",'',$excerpt);
	$excerpt = strip_shortcodes($excerpt);
	$excerpt = strip_tags($excerpt);
	$excerpt = substr($excerpt, 0, 250);	// set the length in character
	$excerpt = substr($excerpt, 0, strripos($excerpt, " "));
	$excerpt = trim(preg_replace( '/\s+/', ' ', $excerpt));
	return $excerpt;
}

/**
 *  Numeric post pagination
 *
 *  @since intensely 1.0
 */

function intensely_numeric_page_navi() {
    global $wp_query;
    $big   = 999999999; // need an unlikely integer
    $pages = paginate_links( array(
            'base' 			=> str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
            'format' 		=> '?paged=%#%',
            'current' 		=> max( 1, get_query_var('paged') ),
            'total' 		=> $wp_query->max_num_pages,
            'prev_next' 	=> false,
            'type'  		=> 'array',
			'prev_text'    	=> '<i class="fa fa-chevron-left" aria-hidden="true"></i>',
			'next_text'    	=> '<i class="fa fa-chevron-right" aria-hidden="true"></i>',
			'end_size'     	=> 3,
			'mid_size'     	=> 3,			
        ) );
        
        if( is_array( $pages ) ) {
            $paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var('paged');
            echo '<ul class="pagination-nav">';
            foreach ( $pages as $page ) {
                    echo '<li> '. $page .' </li>';
            }
           echo '</ul>';
        }
}

/*
 *	Import demo content using plugin
 *	Plugin URL: https://wordpress.org/plugins/one-click-demo-import/
 *
 *	@since intensely 1.0
 */
function intensely_import_files() {
  return array(
    array(
      'import_file_name'           => 'Intensely Demo Content',
      'import_file_url'            => 'https://demo.wpfreeware.com/theme-dummy-data/intensely/intensely.data.xml',
      'import_widget_file_url'     => 'https://demo.wpfreeware.com/theme-dummy-data/intensely/intensely-widgets.wie',
      'import_customizer_file_url' => 'https://demo.wpfreeware.com/theme-dummy-data/intensely/intensely-customizer.dat',
      'import_preview_image_url'   => '',
      'import_notice'              => __( 'After you import dummy content, you will have to setup the front page by going to Settings > Reading.', 'intensely' ),
    ),    
  );
}
add_filter( 'pt-ocdi/import_files', 'intensely_import_files' );

/**
 * 	Load theme updater functions.
 * 	Action is used so that child themes can easily disable.
 *
 *	@since intensely 1.0
 */

function intensely_theme_updater() {
    require( get_template_directory() . '/inc/updater/theme-updater.php' );
}
add_action( 'after_setup_theme', 'intensely_theme_updater' );