<?php
/*
 *	Contains metaboxes for service, portfolio, 
 *	team member & testimonial custom post types.
 *
 *	@version 1.0
 *	@since intensely 1.0
 *
 * 	@package  Demo_CMB2
 * 	@license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * 	@link     https://github.com/WebDevStudios/CMB2
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * 	intensely metaboxes
 *
 *	@since intensely 1.0
 */
function intensely_metaboxes() {

	/*
	 *	set prefix
	 */
	$prefix = '_intensely_';
	
	/**********************************
	 *	Portfolio metabox
	 *
	 *	@since intensely 1.0
	 **********************************/
	$intensely_portfolio_metabox = new_cmb2_box( array(
		'id'            => $prefix . 'portfolio_info',
		'title'         => __( 'Project Demo URL', 'intensely' ),
		'object_types'  => array( 'intensely-portfolio' ), // Post type
		'show_names' 	=> true, // Show field names on the left
		'closed'     	=> true, // true to keep the metabox closed by default
	) );
	// demo button text
	$intensely_portfolio_metabox->add_field( array(
		'name'       	=> __( 'Button Text', 'intensely' ),
		'id'         	=> $prefix . 'portfolio_demo_btn_text',
		'type'       	=> 'text',
	) );
	// demo button url
	$intensely_portfolio_metabox->add_field( array(
		'name'       	=> __( 'Button url', 'intensely' ),
		'id'         	=> $prefix . 'portfolio_demo_btn_url',
		'desc'       	=> __( 'Your project url goes here.', 'intensely' ),		
		'type'       	=> 'text_url',
	) );
	// link target
	$intensely_portfolio_metabox->add_field( array(
	    'name' 			=> __( 'Button target', 'intensely' ),
	    'desc' 			=> __( 'Check to open in a new tab', 'intensely' ),
	    'id'   			=> $prefix . 'portfolio_demo_btn_target',
	    'type' 			=> 'checkbox',
	) );
	
	/*************************************
	 *	Custom Template Metabox
	 *	( Portfolio & Services )
	 *
	 *	@since intensely 1.0
	 *************************************/
	$intensely_title_bar_metabox = new_cmb2_box( array(
		'id'            => $prefix . 'portfolio_template',
		'title'         => __( 'Title Bar', 'intensely' ),
		'object_types'  => array( 'page' ), // Post type
		'show_on'      	=> array( 'key' => 'page-template', 'value' => array( 'template-portfolio.php', 'template-services.php', 'contact.php' ) ),
		'show_names' 	=> true, // Show field names on the left
		'closed'     	=> true, // true to keep the metabox closed by default
	) );
	// title enable/disable
	$intensely_title_bar_metabox->add_field( array(
	    'name'       	=> __( 'Title', 'outlook-pro' ),
	    'id'         	=> $prefix . 'portfolio_template_title_on_off',
	    'desc'       	=> __( 'Hide page title for this page.', 'intensely' ),
	    'type'    		=> 'radio_inline',
	    'options' 		=> array(
	        'intensely-ct-title-on' 	=> __( 'Show', 'intensely' ),
	        'intensely-ct-title-off'   	=> __( 'Hide', 'intensely' ),
	    ),
	    'default' 		=> 'intensely-ct-title-on',
	) );
	// background image
	$intensely_title_bar_metabox->add_field( array(
	    'name'    		=> __( 'Background Image', 'intensely' ),
	    'desc'    		=> __( 'Upload a image to display in the title section background', 'intensely' ),
	    'id'         	=> $prefix . 'ct_title_bg_image',
	    'type'    		=> 'file',
	    'text'    		=> array(
	        'add_upload_file_text' => __( 'Upload Image', 'intensely' ) // Change upload button text. Default: "Add or Upload File"
	    ),
	) );
	// background size
	$intensely_title_bar_metabox->add_field( array(
	    'name'    			=> __( 'Background Size', 'intensely' ),
	    'id'         		=> $prefix . 'ct_title_bg_image_size',
	    'type'             	=> 'select',
	    'default'          	=> 'cover',
	    'options'          	=> array(
	        'cover' 	=> __( 'cover', 'intensely' ),
	        'contain'   => __( 'contain', 'intensely' ),
	        'initial'   => __( 'initial', 'intensely' ),
	    ),
	) );
	// background repeat
	$intensely_title_bar_metabox->add_field( array(
	    'name'    			=> __( 'Background Repeat', 'intensely' ),
	    'id'         		=> $prefix . 'ct_title_bg_image_repeat',
	    'type'             	=> 'select',
	    'default'          	=> 'no-repeat',
	    'options'          	=> array(
	        'no-repeat' => __( 'no-repeat', 'intensely' ),
	        'repeat' 	=> __( 'repeat', 'intensely' ),
	        'initial'   => __( 'initial', 'intensely' ),
	        'repeat-x'  => __( 'repeat-x', 'intensely' ),
	        'repeat-y'  => __( 'repeat-y', 'intensely' ),
	    ),
	) );
}
if( defined( 'CMB2_LOADED' ) ) {
  add_action( 'cmb2_admin_init', 'intensely_metaboxes' );
}