<?php
/*
 *	enqueue theme required styles & scripts
 *	
 *	@version 1.0
 *	@since intensely 1.0
 */
function intensely_scripts() {
	
	 /*
	  *	WP_Theme object
	  *
	  *	@since intensely 1.0
	  */
	 $intensely = wp_get_theme( );
	 
	/*-----------------------------*
	 *	css files
	 *-----------------------------*/
	$font_awesome	=	esc_html( get_theme_mod( 'intensely_font_awesome_option', '1' ) );
	if( $font_awesome ):
	    // font-awesome
		wp_enqueue_style( 'intensely-font-awesome', get_template_directory_uri() . '/css/font-awesome.min.css', array(), '4.7.0', 'all' );
	endif; 
	// bootstrap style
    wp_enqueue_style( 'intensely-bootstrap', get_template_directory_uri() . '/css/bootstrap.css', array(), '3.3.5', 'all' );
	// slick slider styles
    wp_enqueue_style( 'intensely-slickslider', get_template_directory_uri() . '/css/slick.css', array(), $intensely->version, 'all' );
	// bootstrap progress bar
    wp_enqueue_style( 'intensely-bootstrap-progressbar', get_template_directory_uri() . '/css/bootstrap-progressbar-3.3.4.css', array(), $intensely->version, 'all' );
	// intensely main stylesheet
    wp_enqueue_style( 'primary-style', get_template_directory_uri() . '/style.css', false, $intensely->version, 'all' );
    // rtl css
    $rtl = esc_html( get_theme_mod( 'intensely_rtl_option', '0' ) );
    if( $rtl == true ) :
    	wp_enqueue_style( 'intensely-rtl', get_template_directory_uri() . '/css/rtl.css', false, $intensely->version, 'all' );
    endif;  
	// Open-Sans font
    wp_enqueue_style( 'intensely-open-sans', "//fonts.googleapis.com/css?family=Open+Sans", 'all' );
    // Lato font
    wp_enqueue_style( 'intensely-lato-font', "//fonts.googleapis.com/css?family=Lato", 'all' );
    

	/*----------------------------*
	 *	jQuery files
	 *----------------------------*/
	 
	// comment reply
   	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) wp_enqueue_script( 'comment-reply' );
   	
	// bootstrap js
	wp_enqueue_script( 'intensely-bootstrap-js', get_template_directory_uri() . '/js/bootstrap.js', array( 'jquery' ), '3.3.7', true );
	// slick slider js
	wp_enqueue_script( 'intensely-slickslider-js', get_template_directory_uri() . '/js/slick.js', array( 'jquery' ), '1.5.7', true );
	// waypoint
	wp_enqueue_script( 'intensely-waypoint-js', get_template_directory_uri() . '/js/waypoints.js', array(), '2.0.3', true );
	// counter up
	wp_enqueue_script( 'intensely-counterup-js', get_template_directory_uri() . '/js/jquery.counterup.js', array(), '1.0', true );
	// progress bar
	wp_enqueue_script( 'intensely-progressbar-js', get_template_directory_uri() . '/js/bootstrap-progressbar.js', array(), '0.8.5', true );
	// custom js
	wp_enqueue_script( 'intensely-custom-js', get_template_directory_uri() . '/js/custom.js', false, $intensely->version , true );

	// html5shiv & respond - IE Fallbacks
	wp_enqueue_script( 'intensely-html5shiv', get_template_directory_uri(). '/js/html5shiv.js', false, '3.7.3', false);
	wp_script_add_data( 'intensely-html5shiv', 'conditional', 'lt IE 9' );
	wp_enqueue_script( 'intensely-respond', get_template_directory_uri(). '/js/respond.js', false, null, false);
	wp_script_add_data( 'intensely-respond', 'conditional', 'lt IE 9' );

}
add_action( 'wp_enqueue_scripts', 'intensely_scripts' );