<?php
/*
 * 	This file contains dynamic js calls
 *	Content	-	Testimonials Slider
 *
 *	@version 1.0
 *	@since intensely 1.0
 */
 
function intensely_dynamic_js_call(){	?>
	
	<script type="text/javascript">
		
		(function( $ ){
			
			<?php if( is_page_template( 'front-page.php' ) ) : 
				
				/*
				 *	main slider
				 */
				$main_slide_autoplay		=	esc_html( get_theme_mod( 'intensely_main_slide_autoplay_on_off', '0' ) );		
				$main_slide_speed			=	esc_html( get_theme_mod( 'intensely_main_slide_speed', '3000' ) );
				$main_slide_dot_nav			=	esc_html( get_theme_mod( 'intensely_main_slide_dot_nav', '0' ) );
				$main_slide_arrow_nav		=	esc_html( get_theme_mod( 'intensely_main_slide_arrow_nav', '0' ) );
				 
				/*
				 *	Testimonial slider
				 */
				 $testimonial_slide_speed		=	esc_html( get_theme_mod( 'intensely_testimonial_slide_speed', '3000' ) );
				 $testimonial_slide_autoplay	=	esc_html( get_theme_mod( 'intensely_testimonial_autoplay_on_off', '0' ) );
				 $testimonial_slide_dot_nav		=	esc_html( get_theme_mod( 'intensely_testimonial_dot_nav', '0' ) );
				 $testimonial_slide_arrow_nav		=	esc_html( get_theme_mod( 'intensely_testimonial_arrow_nav', '0' ) );
				 
				/*
				 *	Clients slider
				 */
				 $client_slide_amount		=	esc_html( get_theme_mod( 'intensely_clients_logo_slide_amount', '4' ) );
				 $client_slide_autoplay		=	esc_html( get_theme_mod( 'intensely_clients_logo_autoplay_on_off', '0' ) );
				 				
			?>
				
				<?php
				 $featured_slider_enable	=	get_theme_mod( 'intensely_featured_slider', '1' );
				 if( $featured_slider_enable ) : ?>
					/*
					 *	Main slider js
					 */
					$('.main-slider').slick({
						dots: <?php echo ( $main_slide_dot_nav ) ? 'false': 'true'; ?>,
						arrows: <?php echo ( $main_slide_arrow_nav ) ? 'false': 'true'; ?>,
						autoplaySpeed: <?php echo $main_slide_speed; ?>,
						autoplay: <?php echo ( $main_slide_autoplay ) ? 'false': 'true'; ?>,
						infinite: true,
						speed: 500,
						accessibility: false,
						fade: true,
						cssEase: 'linear',
					});
				<?php endif; ?>
				
				<?php
				 $testimonial_section	=	esc_html( get_theme_mod( 'intensely_testimonials_enable_disable', '1' ) );
				 if( $testimonial_section ): ?>
					/*
					 *	Testimonial slider js
					 */
					$('.testimonial-slider').slick({
						dots: <?php echo ( $testimonial_slide_dot_nav ) ? 'false': 'true'; ?>,
						arrows: <?php echo ( $testimonial_slide_arrow_nav ) ? 'false': 'true'; ?>,
						speed: 500,
						autoplaySpeed: <?php echo $testimonial_slide_speed; ?>,
						autoplay: <?php echo ( $testimonial_slide_autoplay ) ? 'false': 'true'; ?>,
						infinite: true,	
						cssEase: 'linear',
					});
				
				<?php endif; ?>
				
				<?php
				$clients_logo_section	=	esc_html( get_theme_mod( 'intensely_clients_logo_enable_disable', '1' ) );
				if( $clients_logo_section ): ?>				
					/*
					 *	Clients logo slider
					 */
					$('.clients-brand-slide').slick({
					  dots: false,
					  infinite: false,
					  speed: 300,
					  slidesToShow: <?php echo $client_slide_amount; ?>,
					  slidesToScroll: <?php echo $client_slide_amount; ?>,
					  autoplay: <?php echo ( $client_slide_autoplay ) ? 'false':'true'; ?>,	
					  responsive: [
					    {
					      breakpoint: 1024,
					      settings: {
					        slidesToShow: 3,
					        slidesToScroll: 3,
					        infinite: true,
					        dots: true
					      }
					    },
					    {
					      breakpoint: 600,
					      settings: {
					        slidesToShow: 2,
					        slidesToScroll: 2
					      }
					    },
					    {
					      breakpoint: 480,
					      settings: {
					        slidesToShow: 1,
					        slidesToScroll: 1
					      }
					    }
					    // You can unslick at a given breakpoint now by adding:
					    // settings: "unslick"
					    // instead of a settings object
					  ]
					});
				<?php endif; ?>
			
			// end home sliders call
			<?php endif; ?>
					
			})( jQuery );		
		
	</script>	
			
<?php
}
add_action( 'wp_footer', 'intensely_dynamic_js_call', 20 );