<?php
/*
 * 	This file contains "testimonials" section dynamic css
 *
 *	@version 1.0
 *	@since intensely 1.0
 */


function intensely_testimonial_section_styles(){
	
	/*
	 *	Set variables
	 *
	 *	@since intensely 1.0
	 */
	$testimonial_bg_image_value 		= 	esc_url( get_theme_mod( 'intensely_testimonial_bg_image', '' ) ); 
	$testimonial_bg_image_url 			= 	'background-image: url( ' . $testimonial_bg_image_value . ' );';
	$testimonial_bg_image 				=	( $testimonial_bg_image_value == '' ) ? '' : $testimonial_bg_image_url;
	
	$testimonial_bg_size 				= 	'background-size:' . esc_html( get_theme_mod( 'intensely_testimonial_bg_size', 'cover' ) ) . ';';
	$testimonial_bg_repeat 				= 	'background-repeat:' . esc_html( get_theme_mod( 'intensely_testimonials_bg_repeat', 'no-repeat' ) ) . ';';


	/*
	 *	testimonial styles
	 *
	 *	@since intensely 1.0
	 */			
	$intensely_testimonial_styles	=	
	
		'<style type="text/css">
		
			#testimonial{
				'. $testimonial_bg_image	.'
				'. $testimonial_bg_size		.'
				'. $testimonial_bg_repeat	.'
			}		
		
		</style>';
	
	if( is_page_template( 'front-page.php' ) ){
		echo $intensely_testimonial_styles;	
	}

}
add_action( 'wp_head', 'intensely_testimonial_section_styles' );