<?php
/*
 * 	This file contains "subscribe" section dynamic css
 *
 *	@version 1.0
 *	@since intensely 1.0
 */

function intensely_subscribe_section_styles(){
	
	/*
	 *	Set variables
	 *
	 *	@since intensely 1.0
	 */
	$subscribe_bg_image_value 		= 	esc_url( get_theme_mod( 'intensely_subscribe_bg_image', '' ) ); 
	$subscribe_bg_image_url 		= 	'background-image: url( ' . $subscribe_bg_image_value . ' );';
	$subscribe_bg_image 			=	( $subscribe_bg_image_value == '' ) ? '' : $subscribe_bg_image_url;
	
	$subscribe_bg_size 				= 	'background-size:' . esc_html( get_theme_mod( 'intensely_subscribe_bg_size', 'cover' ) ) . ';';
	$subscribe_bg_repeat 			= 	'background-repeat:' . esc_html( get_theme_mod( 'intensely_subscribe_bg_repeat', 'no-repeat' ) ) . ';';
	$subscribe_bg_overlay 			= 	'background-color:' . esc_html( get_theme_mod( 'intensely_subscribe_bg_color', 'rgba(0, 0, 0, 0.6)' ) ) . ';';


	/*
	 *	subscribe styles
	 *
	 *	@since intensely 1.0
	 */			
	$intensely_subscribe_styles	=	
	
		'<style type="text/css">
		
			#subscribe{
				'. $subscribe_bg_image		.'
				'. $subscribe_bg_size		.'
				'. $subscribe_bg_repeat		.'
			}
			.subscribe-overlay{
				'. $subscribe_bg_overlay 	.'
			}
		
		</style>';
	
	echo $intensely_subscribe_styles;	

}
add_action( 'wp_head', 'intensely_subscribe_section_styles' );