<?php
/*
 * 	This file contains "portfolio template" title section dynamic css
 *
 *	@version 1.0
 *	@since intensely 1.0
 */


function intensely_custom_template_title_bar(){
	
	/*
	 *	Set variables
	 *
	 *	@since intensely 1.0
	 */
	$ct_title_bg 			= 	esc_url( get_post_meta( get_the_ID(), '_intensely_ct_title_bg_image', true ) );
	$ct_title_bg_url 		= 	'background-image: url( ' . $ct_title_bg . ' );';
	$ct_title_bg_image 		=	( $ct_title_bg == '' ) ? '' : $ct_title_bg_url;
	
	$ct_bg_size 			= 	'background-size:' . esc_html( get_post_meta( get_the_ID(), '_intensely_ct_title_bg_image_size', true ) ) . ';';
	$ct_bg_repeat 			= 	'background-repeat:' . esc_html( get_post_meta( get_the_ID(), '_intensely_ct_title_bg_image_repeat', true ) ) . ';';


	/*
	 *	portfolio title bar styles
	 *
	 *	@since intensely 1.0
	 */			
	$intensely_ct_title_bar_styles	=	
	
		'<style type="text/css">
		
			#single-page-header{
				'. $ct_title_bg_image		.'
				'. $ct_bg_size				.'
				'. $ct_bg_repeat			.'
			}		
		
		</style>';
	
	if( is_page_template( 'template-portfolio.php' ) || is_page_template( 'template-services.php' ) || is_page_template( 'contact.php' ) ){
		echo $intensely_ct_title_bar_styles;	
	}	

}
add_action( 'wp_head', 'intensely_custom_template_title_bar' );