<?php
/*
 * 	This file contains "Counter" section dynamic css
 *
 *	@version 1.0
 *	@since intensely 1.0
 */


function intensely_counter_section_styles(){
	
	/*
	 *	Set variables
	 *
	 *	@since intensely 1.0
	 */
	$counter_bg_image_value 		= 	esc_url( get_theme_mod( 'intensely_counter_bg_image', '' ) ); 
	$counter_bg_image_url 			= 	'background-image: url( ' . $counter_bg_image_value . ' );';
	$counter_bg_image 				=	( $counter_bg_image_value == '' ) ? '' : $counter_bg_image_url;
	
	$counter_bg_size 				= 	'background-size:' . esc_html( get_theme_mod( 'intensely_counter_bg_size', 'cover' ) ) . ';';
	$counter_bg_repeat 				= 	'background-repeat:' . esc_html( get_theme_mod( 'intensely_counter_bg_repeat', 'no-repeat' ) ) . ';';
	$counter_bg_color 				= 	'background-color:' . esc_html( get_theme_mod( 'intensely_counter_bg_color', 'rgba(0, 0, 0, 0.6)' ) ) . ';';


	/*
	 *	Counter styles
	 *
	 *	@since intensely 1.0
	 */			
	$intensely_counter_styles	=	
	
		'<style type="text/css">
		
			#counter{
				'. $counter_bg_image				.'
				'. $counter_bg_size					.'
				'. $counter_bg_repeat				.'
			}
								
			.counter-overlay{
				'. $counter_bg_color				.'
			}		
		
		</style>';
	
	if( is_page_template( 'front-page.php' ) ){
		echo $intensely_counter_styles;	
	}	

}
add_action( 'wp_head', 'intensely_counter_section_styles' );