<?php
/*
 * 	This file contains theme color scheme
 *
 *	@version 1.0
 *	@since intensely 1.0
 */

function intensely_site_color_scheme(){
	
	/*
	 *	Set variable
	 *
	 *	@since intensely 1.0
	 */
	
	// color
	$theme_color 	= 	esc_html( get_theme_mod( 'intensely_color_scheme', '#2bcdc1' ) ); 


	/*
	 *	Site main color scheme
	 *
	 *	@since intensely 1.0
	 */			
	$site_color_scheme	=	
	
		'<style type="text/css">
		
			.login:hover,
			.login:focus,
			.main-nav > li > a:hover::before,
			.navbar-default .navbar-nav > .active > a::before,
			.navbar-default .navbar-nav > .open > a:hover::before,
			.main-slider .slick-prev:hover,
			.main-slider .slick-next:hover,
			.read-more-btn:hover,
			.read-more-btn:focus,
			.our-skill h3::after,
			.our-skill-content .progress-bar,
			.why-choose-us h3::after,
			.single-counter .counter-label::after,
			.price-title,
			.featured-price .price-header,
			.single-team-member:hover .team-member-link,
			.subscribe-btn,
			.scrollToTop,
			.widget-title::after,
			.search-group .blog-search-btn,
			.comments .blog-pagination > li > a:hover, 
			.comments .blog-pagination > li > span:hover,
			.comments .blog-pagination > li > a:focus, 
			.comments .blog-pagination > li > span:focus,
			.comments .blog-pagination > li > a.current,
			.comments-box-area h2::after,
			.contact-area-left h4::after,
			.loginbox .signin-btn,
			.navbar-default .navbar-toggle .icon-bar,
			.error-content .error-home,
			.blog-comments-reply-area h3::after,
			.il-related-post h3::after,
			.comment-respond h3::after,
			.comment-respond .comment-reply-title::after {
				background-color: ' . $theme_color . '; 
			}
			
			.navbar-default .navbar-nav > li > a:hover,
			.navbar-default .navbar-nav > li > a:focus {
				color: ' . $theme_color . ' !important;  
			}
			
			.navbar-default .navbar-brand,
			.navbar-default .navbar-brand:hover,
			.navbar-default .navbar-brand:focus,
			.navbar-default .navbar-nav > .active > a,
			.navbar-default .navbar-nav > .active > a:hover,
			.navbar-default .navbar-nav > .active > a:focus,
			.main-nav .dropdown:hover .dropdown-toggle,
			.navbar-default .navbar-nav > .open > a, 
			.navbar-default .navbar-nav > .open > a:hover, 
			.navbar-default .navbar-nav > .open > a:focus,
			.navbar-nav > li > .dropdown-menu > li > a:hover,
			.navbar-nav > li > .dropdown-menu > li > a:focus,
			.main-slider .slick-dots li button::before,
			.title-area .title,
			.single-feature .feature-icon,
			.feat-title,
			.our-skill h3,
			.why-choose-us h3,
			.panel-title > a:hover,
			.panel-title > a:focus,
			.testimonial-content h6 span,
			.blog-news-title h2>a:hover,
			.blog-news-title .blog-author:hover,
			.blog-more-btn:hover,
			.blog-more-btn:focus,
			.view-icon:hover,
			.sidebar-widget ul>li>a:hover,
			.widget-catg li,
			.widget-catg li a:hover,
			.widget-catg li a:focus,
			.widget-archive li a:hover,
			.widget-archive li a:focus,
			.blog-single-tag a:hover,
			.blog-single-tag a:focus,
			.blog-navigation-prev a>span,
			.blog-navigation-next a>span,
			.footer-box a:hover,
			.footer-box a:focus,
			.signupbox span a:hover,
			#search-icon,
			#signup-content .modal-title,
			#login-content .modal-title,
			.service-icon,
			.footer-left p a:hover,
			.footer-right a:hover,
			.single-page-header-right .breadcrumb li,
			.error-content span,
			.blog-single-details a:hover,
			.blog-single-details a:focus,
			.blog-news-details a:hover,
			.blog-news-details a:focus,			
			.blog-comments-reply-area .comments .commentlist li .media-body a:hover,
			.single-page-header-right .breadcrumb span,
			.blog-news-title a:hover,
			.blog-news-title a:focus,
			.singlepost-pagination a:hover,
			.singlepost-pagination a:focus,
			.widget_categories li::before,
			.widget_recent_comments ul li a:hover {
				color: ' . $theme_color . ';
			}
			
			.main-nav .dropdown:hover .dropdown-toggle::before{
				background-color: ' . $theme_color . ';
				color: ' . $theme_color . '; 
			}
			
			.navbar-nav > li > .dropdown-menu {
				border-top: 2px solid ' . $theme_color . ';  
			}
			
			.purchase-btn:hover,
			.purchase-btn:focus,
			.featured-price .purchase-btn,
			.portfolio-menu ul li:hover,
			.portfolio-menu ul li.active,
			.pagination-nav li a:hover,
			.pagination-nav li a:focus,
			.comment-btn:hover,
			.tagcloud a:hover,
			.tagcloud a:focus,
			.wpcf7-form .wpcf7-submit:hover,
			.comment-form .submit:hover,
			.blog-pagination .current,
			.blog-pagination a:hover,
			.blog-pagination a:focus {
				background-color: ' . $theme_color . ';
				border-color: ' . $theme_color . ';  
			}
			
			.team-member-img,
			.single-team-member:hover,
			.team-member-link {  
				border: 2px solid ' . $theme_color . ';  
			}
			
			.testimonial-slider .slick-dots li,
			.search-group input[type="search"],
			.comment-form input[type="text"]:focus,
			.comment-form input[type="email"]:focus,
			.comment-form input[type="url"]:focus,
			.comment-form textarea:focus,
			.blog-archive-area .sticky {
				border: 1px solid ' . $theme_color . '; 
			}
			
			.scrollToTop:hover,
			.scrollToTop:focus{
				color: ' . $theme_color . ';
				border: 1px solid ' . $theme_color . '; 
			}
			
			.single-item-content::after {
				border: 4px solid ' . $theme_color . ';  
			}
			
			.search-group input[type="search"]:focus,
			.comments-form .form-control:focus,
			#login-content .form-control:focus,
			#signup-content .form-control:focus,
			.navbar-default .navbar-toggle,
			.wpcf7-form .wpcf7-form-control:focus {
				border-color: ' . $theme_color . ';
			}
			
			.error-title {
				background-color: ' . $theme_color . ';
				border: 2px solid ' . $theme_color . ';  
			}
			
			.il-author-social li a:hover,
			.il-author-social li a:focus,
			.blog-single-social a:hover,
			.blog-single-social a:focus {
				border-color: ' . $theme_color . ';
				color: ' . $theme_color . ';
			}	
					
		</style>';
	
	
	echo $site_color_scheme;	

}
add_action( 'wp_head', 'intensely_site_color_scheme' ); 