<?php
/*
 *	This file contains "Header" section & fields.
 *	
 *	@version 1.0
 *	@since intensely 1.0
 */
	
	/*
	 *	Section -- Header
	 *
	 *	@since intensely 1.0
	 */
	 
	intensely_Kirki::add_section( 'intensely_header_section', array(
	    'title'          	=> __( 'Header', 'intensely' ),
	    'priority'       	=> 8,
	    'capability'     	=> 'edit_theme_options',
	) );
	
	// header top enable/disable
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        => 'switch',
		'settings'    => 'intensely_header_top',
		'label'       => __( 'Header Top', 'intensely' ),
		'section'     => 'intensely_header_section',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => array(
			'on'  => esc_attr__( 'Enable', 'intensely' ),
			'off' => esc_attr__( 'Disable', 'intensely' ),
		),
	) );
	// phone
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     => 'text',
		'settings' => 'intensely_header_top_phone',
		'label'    => __( 'Phone', 'intensely' ),
		'section'  => 'intensely_header_section',
		'default'  => '',
		'priority' => 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_header_top',
				'operator' 		=> '==',
				'value'    		=> '1',
			),
		),				
	) );
	// email
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     => 'text',
		'settings' => 'intensely_header_top_email',
		'label'    => __( 'Email', 'intensely' ),
		'section'  => 'intensely_header_section',
		'default'  => '',
		'priority' => 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_header_top',
				'operator' 		=> '==',
				'value'    		=> '1',
			),
		),				
	) );
	
	// search icon
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'checkbox',
		'settings' 			=> 'intensely_header_bottom_search',
		'label'    			=> __( 'Check to hide search icon', 'intensely' ),
		'section'  			=> 'intensely_header_section',
		'priority' 			=> 10,
		'default'     		=> '0',		
	) );	