<?php
/*
 *	This file contains theme general setting options.
 *	Controls: preloaders, scroll top, site layout (box/wide)
 *	
 *	@version 1.0
 *	@since intensely 1.0
 */
	
	/*
	 *	Section -- general settings
	 *
	 *	@since intensely 1.0
	 */
	 
	intensely_Kirki::add_section( 'intensely_general_settings_section', array(
	    'title'          	=> __( 'General Settings', 'intensely' ),
	    'priority'       	=> 8,
	    'capability'     	=> 'edit_theme_options',
	) );	
	
	// theme color
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        => 'color',
		'settings'    => 'intensely_color_scheme',
		'label'       => __( 'Site color scheme', 'intensely' ),
		'section'     => 'intensely_general_settings_section',
		'default'     => '#2bcdc1',
		'priority'    => 10,
		'alpha'       => true,
	) );	
	
	// enable/disable preloader
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'checkbox',
		'settings' 			=> 'intensely_preloaders_option',
		'label'    			=> __( 'Check to disable preloader', 'intensely' ),
		'section'  			=> 'intensely_general_settings_section',
		'priority' 			=> 10,
		'default'     		=> '1',		
	) );
	
	// on/off scroll top
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'checkbox',
		'settings' 			=> 'intensely_scroll_top',
		'label'    			=> __( 'Check to disable scroll top', 'intensely' ),
		'section'  			=> 'intensely_general_settings_section',
		'priority' 			=> 10,
		'default'     		=> '0',		
	) );
	
	// font-awesome enable/disable
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'switch',
		'settings'    		=> 'intensely_font_awesome_option',
		'label'       		=> __( 'Font Awesome', 'intensely' ),
		'description'       => __( 'Enable/disable font-awesome icons css to improve site performance. Useful if you\'re using a plugin that uses font-awesome.', 'intensely' ),
		'section'     		=> 'intensely_general_settings_section',
		'default'     		=> '1',
		'priority'    		=> 10,
		'choices'     		=> array(
			'on'  => esc_attr__( 'Enable', 'intensely' ),
			'off' => esc_attr__( 'Disable', 'intensely' ),
		),
	) );
	
	// RTL enable/disable
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'switch',
		'settings'    		=> 'intensely_rtl_option',
		'label'       		=> __( 'RTL', 'intensely' ),
		'section'     		=> 'intensely_general_settings_section',
		'default'     		=> '0',
		'priority'    		=> 10,
		'choices'     		=> array(
			'on'  => esc_attr__( 'Enable', 'intensely' ),
			'off' => esc_attr__( 'Disable', 'intensely' ),
		),
	) );