<?php
/*
 *	This file contains "Testimonials" section & fields 
 *	
 *	@version 1.0
 *	@since intensely 1.0
 */
 
  	/*
	 *	Section -- Testimonials | Front Page
	 *
	 *	@since intensely 1.0
	 */
	 
	intensely_Kirki::add_section( 'intensely_testimonials_section', array(
	    'title'          	=> __( 'Testimonials', 'intensely' ),
	    'priority'       	=> 10,
	    'panel'       	 	=> 'intensely_front_page_panel',
	    'capability'     	=> 'edit_theme_options',
	) );
	
	
	/*
	 *	Fields -- Testimonials
	 *	Fields - Enable,Disable | Title | 
	 *
	 *	@since intensely 1.0
	 */
	 
	// enable/disable
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'switch',
		'settings'    		=> 'intensely_testimonials_enable_disable',
		'label'       		=> __( 'Enable or disable testimonials section', 'intensely' ),		
		'section'     		=> 'intensely_testimonials_section',
		'default'     		=> '1',
		'priority'    		=> 10,
		'choices'     		=> array(
			'on'  				=> esc_attr__( 'Enable', 'intensely' ),
			'off' 				=> esc_attr__( 'Disable', 'intensely' ),
		),
	) );
	 
    // background image
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'image',
		'settings'    		=> 'intensely_testimonial_bg_image',
		'label'       		=> __( 'Background Image', 'intensely' ),
		'section'     		=> 'intensely_testimonials_section',
		'default'     		=> '',
		'priority'    		=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_testimonials_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),			
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '#testimonial',
                'function' 		=> 'css',
                'property' 		=> 'background-image',
            ),
        ),			
	) );
	
	// background size
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'select',
		'settings'    		=> 'intensely_testimonial_bg_size',
		'label'       		=> __( 'Background size', 'intensely' ),
		'section'     		=> 'intensely_testimonials_section',
		'default'     		=> 'cover',
		'priority'    		=> 10,
		'multiple'    		=> 1,
		'choices'     		=> array(
			'cover' 			=> esc_attr__( 'cover', 'intensely' ),
			'contain' 			=> esc_attr__( 'contain', 'intensely' ),
			'initial' 			=> esc_attr__( 'initial', 'intensely' ),
		),
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_testimonials_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),			
		),		
	) );
	
	// background repeat
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'select',
		'settings'    		=> 'intensely_testimonials_bg_repeat',
		'label'       		=> __( 'Background repeat', 'intensely' ),
		'section'     		=> 'intensely_testimonials_section',
		'default'     		=> 'no-repeat',
		'priority'    		=> 10,
		'multiple'    		=> 1,
		'choices'     		=> array(
			'repeat' 			=> esc_attr__( 'Repeat', 'intensely' ),
			'repeat-x' 			=> esc_attr__( 'Repeat X', 'intensely' ),
			'repeat-y' 			=> esc_attr__( 'Repeat Y', 'intensely' ),
			'no-repeat' 		=> esc_attr__( 'No Repeat', 'intensely' ),
		),
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_testimonials_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),			
		),		
	) );
	
	// title
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'text',
		'settings' 			=> 'intensely_testimonials_title',
		'label'    			=> __( 'Title', 'intensely' ),
		'section'  			=> 'intensely_testimonials_section',
		'default'  			=> '',
		'priority' 			=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_testimonials_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '#testimonial .title-area .title',
                'function' 		=> 'html',
            ),
        ),				
	) );
	
	// testimonials
    intensely_Kirki::add_field( 'intensely_config', array(
        'type'        		=> 'repeater',
        'settings'    		=> 'intensely_testimonials_option',        
        'label'       		=> __( 'Add Testimonials', 'intensely' ),
        'section'     		=> 'intensely_testimonials_section',				        
        'priority'    		=> 10,
        'default'     		=> array(),
        'row_label' 		=> array(               
	        'type' 							=> 'text',
	        'value' 						=> esc_attr__( 'testimonial', 'intensely' ),
		),
		'active_callback'   => array(
			array(
				'setting'  					=> 'intensely_testimonials_enable_disable',
				'operator' 					=> '==',
				'value'    					=> 1,
			),
		),		        
        'fields' 			=> array(
                'intensely_tm_image'  		=> array(
                'type'                  	=> 'image',
                'label'                 	=> esc_attr__( 'Upload Image', 'intensely' ),
                'description' 				=> esc_attr__( 'Best image size: 100x100', 'intensely' ),
                'default'               	=> '',
            ),
                'intensely_tm_desc'  		=> array(
                'type'                  	=> 'textarea',
                'label'                 	=> esc_attr__( 'Description', 'intensely' ),
                'default'               	=> '',
            ),
                'intensely_tm_name'  		=> array(
                'type'                  	=> 'text',
                'label'                 	=> esc_attr__( 'Name', 'intensely' ),
                'default'               	=> '',
            ),
                'intensely_tm_position'  	=> array(
                'type'                  	=> 'text',
                'label'                 	=> esc_attr__( 'Position', 'intensely' ),
                'default'               	=> '',
            ),                                                          
        )
    ) );	
	
	// testimonial slide speed
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        => 'slider',
		'settings'    => 'intensely_testimonial_slide_speed',
		'label'       => __( 'Testimonial Slide speed (ms)', 'intensely' ),
		'section'     => 'intensely_testimonials_section',
		'default'     => 3000,
		'choices'     => array(
			'min'  => '3000',
			'max'  => '100000',
			'step' => '1000',
		),
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_testimonials_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),		
	) );	
	
	// testimonial slide autoplay
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'checkbox',
		'settings' 			=> 'intensely_testimonial_autoplay_on_off',
		'label'    			=> __( 'Disable slide autoplay', 'intensely' ),
		'section'  			=> 'intensely_testimonials_section',
		'priority' 			=> 10,
		'default'     		=> '0',
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_testimonials_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),				
	) );	
	
	// testimonial slide dot nav	
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'checkbox',
		'settings' 			=> 'intensely_testimonial_dot_nav',
		'label'    			=> __( 'Disable slide dot nav', 'intensely' ),
		'section'  			=> 'intensely_testimonials_section',
		'priority' 			=> 10,
		'default'     		=> '0',
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_testimonials_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),				
	) );
	// testimonial slide arrow nav	
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'checkbox',
		'settings' 			=> 'intensely_testimonial_arrow_nav',
		'label'    			=> __( 'Disable slide arrow nav', 'intensely' ),
		'section'  			=> 'intensely_testimonials_section',
		'priority' 			=> 10,
		'default'     		=> '0',
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_testimonials_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),				
	) );