<?php
/*
 *	This file contains "Team Members" section & fields 
 *	
 *	@version 1.0
 *	@since intensely 1.0
 */
 
  	/*
	 *	Section -- Team Members | Front Page
	 *
	 *	@since intensely 1.0
	 */
	 
	intensely_Kirki::add_section( 'intensely_team_members_section', array(
	    'title'          	=> __( 'Team Members', 'intensely' ),
	    'priority'       	=> 10,
	    'panel'       	 	=> 'intensely_front_page_panel',
	    'capability'     	=> 'edit_theme_options',
	) );
	
	
	/*
	 *	Fields -- Team Members
	 *	Fields - Enable, Disable | Title | Description | Repeater Field ( Image | Name | Position | Description | Facebook | Twitter | LinkedIn )
	 *
	 *	@since intensely 1.0
	 */
	 
	// enable/disable
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'switch',
		'settings'    		=> 'intensely_team_members_enable_disable',
		'label'       		=> __( 'Enable or disable Team Members section', 'intensely' ),		
		'section'     		=> 'intensely_team_members_section',
		'default'     		=> '1',
		'priority'    		=> 10,
		'choices'     		=> array(
			'on'  				=> esc_attr__( 'Enable', 'intensely' ),
			'off' 				=> esc_attr__( 'Disable', 'intensely' ),
		),
	) );
	
	// title
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'text',
		'settings' 			=> 'intensely_team_members_title',
		'label'    			=> __( 'Title', 'intensely' ),
		'section'  			=> 'intensely_team_members_section',
		'default'  			=> '',
		'priority' 			=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_team_members_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '#our-team .title-area .title',
                'function' 		=> 'html',
            ),
        ),				
	) );
	
	// description
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'textarea',
		'settings' 			=> 'intensely_team_members_desc',
		'label'    			=> __( 'Title', 'intensely' ),
		'section'  			=> 'intensely_team_members_section',
		'default'  			=> '',
		'priority' 			=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_team_members_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '#our-team .title-area p',
                'function' 		=> 'html',
            ),
        ),				
	) );
	
	// members
    intensely_Kirki::add_field( 'intensely_config', array(
        'type'        		=> 'repeater',
        'settings'    		=> 'intensely_team_members_option',        
        'label'       		=> __( 'Add Team Members', 'intensely' ),
        'section'     		=> 'intensely_team_members_section',				        
        'priority'    		=> 10,
        'default'     		=> array(),
        'row_label' 		=> array(               
	        'type' 							=> 'text',
	        'value' 						=> esc_attr__( 'member', 'intensely' ),
		),
		'active_callback'   => array(
			array(
				'setting'  					=> 'intensely_team_members_enable_disable',
				'operator' 					=> '==',
				'value'    					=> 1,
			),
		),		        
        'fields' 			=> array(
                'intensely_member_image'   	=> array(
                'type'                  	=> 'image',
                'label'                 	=> esc_attr__( 'Image', 'intensely' ),
                'description' 				=> esc_attr__( 'Best image size is: 240x260', 'intensely' ),
                'default'               	=> '',                
            ),                                       
                'intensely_member_name'   	=> array(
                'type'                  	=> 'text',
                'label'                 	=> esc_attr__( 'Name', 'intensely' ),
                'default'               	=> '',                
            ),
                'intensely_member_position' => array(
                'type'                  	=> 'text',
                'label'                 	=> esc_attr__( 'Position', 'intensely' ),
                'default'               	=> '',                
            ),            
                'intensely_member_desc'  	=> array(
                'type'                  	=> 'textarea',
                'label'                 	=> esc_attr__( 'Description', 'intensely' ),
                'default'               	=> '',
            ),
                'intensely_member_facebook' => array(
                'type'                  	=> 'text',
                'label'                 	=> esc_attr__( 'Facebook url', 'intensely' ),
                'default'               	=> '',                
            ),
                'intensely_member_twitter'  => array(
                'type'                  	=> 'text',
                'label'                 	=> esc_attr__( 'Twitter url', 'intensely' ),
                'default'               	=> '',                
            ),
                'intensely_member_linkedin' => array(
                'type'                  	=> 'text',
                'label'                 	=> esc_attr__( 'LinkedIn url', 'intensely' ),
                'default'               	=> '',                
            ),                                                                                                           
        )
    ) ); 