<?php
/*
 *	This file contains "Services" section & fields 
 *	
 *	@version 1.0
 *	@since intensely 1.0
 */
 
  	/*
	 *	Section -- Service | Front Page
	 *
	 *	@since intensely 1.0
	 */
	 
	intensely_Kirki::add_section( 'intensely_services_section', array(
	    'title'          	=> __( 'Services', 'intensely' ),
	    'priority'       	=> 10,
	    'panel'       	 	=> 'intensely_front_page_panel',
	    'capability'     	=> 'edit_theme_options',
	) );
	
	
	/*
	 *	Fields -- Services | Services Section
	 *	Fields - Title | Description | Repeater Field ( icon | service | service description )
	 *
	 *	@since intensely 1.0
	 */
	 
	// enable/disable
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'switch',
		'settings'    		=> 'intensely_services_enable_disable',
		'label'       		=> __( 'Enable or disable Services section', 'intensely' ),		
		'section'     		=> 'intensely_services_section',
		'default'     		=> '1',
		'priority'    		=> 10,
		'choices'     		=> array(
			'on'  				=> esc_attr__( 'Enable', 'intensely' ),
			'off' 				=> esc_attr__( 'Disable', 'intensely' ),
		),
	) );
	
	// title
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'text',
		'settings' 			=> 'intensely_services_title',
		'label'    			=> __( 'Title', 'intensely' ),
		'section'  			=> 'intensely_services_section',
		'default'  			=> '',
		'priority' 			=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_services_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '#service .title-area .title',
                'function' 		=> 'html',
            ),
        ),				
	) );
	
	// Description
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'textarea',
		'settings' 			=> 'intensely_services_desc',
		'label'    			=> __( 'Description', 'intensely' ),
		'section'  			=> 'intensely_services_section',
		'default'  			=> '',
		'priority' 			=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_services_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '#service .title-area p',
                'function' 		=> 'html',
            ),
        ),				
	) );
	
	// Services
    intensely_Kirki::add_field( 'intensely_config', array(
        'type'        		=> 'repeater',
        'settings'    		=> 'intensely_services_option',        
        'label'       		=> __( 'Add Service', 'intensely' ),
        'section'     		=> 'intensely_services_section',				        
        'priority'    		=> 10,
        'default'     		=> array(),
        'row_label' 		=> array(               
	        'type' 							=> 'text',
	        'value' 						=> esc_attr__( 'service', 'intensely' ),
		),
		'active_callback'   => array(
			array(
				'setting'  					=> 'intensely_services_enable_disable',
				'operator' 					=> '==',
				'value'    					=> 1,
			),
		),		        
        'fields' 			=> array(
                'intensely_service_icon'    => array(
                'type'                  	=> 'select',
                'label'                 	=> esc_attr__( 'Icon', 'intensely' ),
                'choices'     				=> intensely_font_awesome(),                
                'default'               	=> '',               
            ),
                'intensely_service_title'   => array(
                'type'                  	=> 'text',
                'label'                 	=> esc_attr__( 'Title', 'intensely' ),
                'default'               	=> '',                
            ),
                'intensely_service_desc'  	=> array(
                'type'                  	=> 'textarea',
                'label'                 	=> esc_attr__( 'Description', 'intensely' ),
                'default'               	=> '',
            ),                                                          
        )
    ) );    