<?php
/*
 *	This file contains "Pricing Tables" section & fields 
 *	
 *	@version 1.0
 *	@since intensely 1.0
 */
 
  	/*
	 *	Section -- Pricing Tables | Front Page
	 *
	 *	@since intensely 1.0
	 */
	 
	intensely_Kirki::add_section( 'intensely_pricing_section', array(
	    'title'          	=> __( 'Pricing Tables', 'intensely' ),
	    'priority'       	=> 10,
	    'panel'       	 	=> 'intensely_front_page_panel',
	    'capability'     	=> 'edit_theme_options',
	) );
	
	
	/*
	 *	Fields -- Pricing Tables
	 *	Fields - Enable,Disable | Title | Description | Repeater Field ( Price title | price | price options(10) | button text | button url | button target )
	 *
	 *	@since intensely 1.0
	 */
	 
	// enable/disable
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'switch',
		'settings'    		=> 'intensely_pricing_enable_disable',
		'label'       		=> __( 'Enable or disable pricing section', 'intensely' ),		
		'section'     		=> 'intensely_pricing_section',
		'default'     		=> '1',
		'priority'    		=> 10,
		'choices'     		=> array(
			'on'  				=> esc_attr__( 'Enable', 'intensely' ),
			'off' 				=> esc_attr__( 'Disable', 'intensely' ),
		),
	) );
	
	// title
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'text',
		'settings' 			=> 'intensely_pricing_title',
		'label'    			=> __( 'Title', 'intensely' ),
		'section'  			=> 'intensely_pricing_section',
		'default'  			=> '',
		'priority' 			=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_pricing_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '.ol-pricing-table-area .ol-title-area .ol-title',
                'function' 		=> 'html',
            ),
        ),				
	) );
	
	// description
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'textarea',
		'settings' 			=> 'intensely_pricing_desc',
		'label'    			=> __( 'Description', 'intensely' ),
		'section'  			=> 'intensely_pricing_section',
		'default'  			=> '',
		'priority' 			=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_pricing_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '.ol-pricing-table-area .ol-title-area p',
                'function' 		=> 'html',
            ),
        ),				
	) );	
	
	// pricing table
    intensely_Kirki::add_field( 'intensely_config', array(
        'type'        		=> 'repeater',
        'settings'    		=> 'intensely_pricing_option',        
        'label'       		=> __( 'Add Pricing Tables', 'intensely' ),
        'description'       => __( 'Please include maximum 4 tables', 'intensely' ),
        'section'     		=> 'intensely_pricing_section',				        
        'priority'    		=> 10,
        'default'     		=> array(),
        'row_label' 		=> array(               
	        'type' 									=> 'text',
	        'value' 								=> esc_attr__( 'table', 'intensely' ),
		),
		'active_callback'   => array(
			array(
				'setting'  							=> 'intensely_pricing_enable_disable',
				'operator' 							=> '==',
				'value'    							=> 1,
			),
		),		        
        'fields' 			=> array(                                       
                'intensely_pricing_table_title'   	=> array(
                'type'                  			=> 'text',
                'label'                 			=> esc_attr__( 'Title', 'intensely' ),
                'default'               			=> '',                
            ),
                'intensely_pricing_table_price'   	=> array(
                'type'                  			=> 'text',
                'label'                 			=> esc_attr__( 'Price', 'intensely' ),
                'default'               			=> '',                
            ),
                'intensely_pricing_table_currency'  => array(
                'type'                  			=> 'text',
                'label'                 			=> esc_attr__( 'Currency sign', 'intensely' ),
                'default'               			=> '$',                
            ),
                'intensely_pricing_table_payroll'  => array(
                'type'                  			=> 'text',
                'label'                 			=> esc_attr__( 'Yearly/ Monthly / Weekly', 'intensely' ),
                'default'               			=> esc_attr__( 'MO', 'intensely' ),                
            ),
                'intensely_pricing_table_feature_1'	=> array(
                'type'                  			=> 'text',
                'label'                 			=> esc_attr__( 'Feature 1', 'intensely' ),
                'default'               			=> '',                
            ),
                'intensely_pricing_table_feature_2'	=> array(
                'type'                  			=> 'text',
                'label'                 			=> esc_attr__( 'Feature 2', 'intensely' ),
                'default'               			=> '',                
            ),
                'intensely_pricing_table_feature_3'	=> array(
                'type'                  			=> 'text',
                'label'                 			=> esc_attr__( 'Feature 3', 'intensely' ),
                'default'               			=> '',                
            ),
                'intensely_pricing_table_feature_4'	=> array(
                'type'                  			=> 'text',
                'label'                 			=> esc_attr__( 'Feature 4', 'intensely' ),
                'default'               			=> '',                
            ),
                'intensely_pricing_table_feature_5'	=> array(
                'type'                  			=> 'text',
                'label'                 			=> esc_attr__( 'Feature 5', 'intensely' ),
                'default'               			=> '',                
            ),
                'intensely_pricing_table_feature_6'	=> array(
                'type'                  			=> 'text',
                'label'                 			=> esc_attr__( 'Feature 6', 'intensely' ),
                'default'               			=> '',                
            ),
                'intensely_pricing_table_feature_7'	=> array(
                'type'                  			=> 'text',
                'label'                 			=> esc_attr__( 'Feature 7', 'intensely' ),
                'default'               			=> '',                
            ),
                'intensely_pricing_table_feature_8'	=> array(
                'type'                  			=> 'text',
                'label'                 			=> esc_attr__( 'Feature 8', 'intensely' ),
                'default'               			=> '',                
            ),
                'intensely_pricing_table_feature_9'	=> array(
                'type'                  			=> 'text',
                'label'                 			=> esc_attr__( 'Feature 9', 'intensely' ),
                'default'               			=> '',                
            ),
                'intensely_pricing_table_feature_10'=> array(
                'type'                  			=> 'text',
                'label'                 			=> esc_attr__( 'Feature 10', 'intensely' ),
                'default'               			=> '',                
            ),
                'intensely_pricing_table_button_text'=> array(
                'type'                  			=> 'text',
                'label'                 			=> esc_attr__( 'Button Text', 'intensely' ),
                'default'               			=> '',                
            ),
                'intensely_pricing_table_button_url'=> array(
                'type'                  			=> 'text',
                'label'                 			=> esc_attr__( 'Button URL', 'intensely' ),
                'default'               			=> '',                
            ),
                'intensely_pricing_table_button_target'=> array(
                'type'                  			=> 'checkbox',
                'label'                 			=> esc_attr__( 'Check to open in a new window', 'intensely' ),
                'default'               			=> false,
            ),
                'intensely_pricing_table_featured'=> array(
                'type'                  			=> 'checkbox',
                'label'                 			=> esc_attr__( 'Check to make this table featured', 'intensely' ),
                'default'               			=> false,
            ),                                                                                                                                                                                                                                                     
        )
    ) );