<?php
/*
 *	This file contains Portfolio section & fields 
 *	
 *	@version 1.0
 *	@since intensely 1.0
 */
 
	/*
	 *	Section -- Portfolio | Front Page
	 *
	 *	@since intensely 1.0
	 */
	 
	intensely_Kirki::add_section( 'intensely_portfolio_section', array(
	    'title'          => __( 'Portfolio', 'intensely' ),
	    'priority'       => 10,
	    'panel'       	 => 'intensely_front_page_panel',
	    'capability'     => 'edit_theme_options',
	) );
	/*
	 *	Fields -- Portfolio
	 *	Fields - Switch | Help text | Title | Descritpion
	 *
	 *	@since intensely 1.0
	 */
	// enable/disable	
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'switch',
		'settings'    		=> 'intensely_portfolio_enable_disable',
		'label'       		=> __( 'Enable or disable Portfolio section', 'intensely' ),		
		'section'     		=> 'intensely_portfolio_section',
		'default'     		=> '1',
		'priority'    		=> 10,
		'choices'     		=> array(
			'on'  => esc_attr__( 'Enable', 'intensely' ),
			'off' => esc_attr__( 'Disable', 'intensely' ),
		),
	) );
	
	// portfolio help text
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'custom',
		'settings'    		=> 'intensely_portfolio_help_text',
		'section'     		=> 'intensely_portfolio_section',
		'default'     		=> '<div style="background:#ffffff;padding:7px;"> '. esc_html__( 'Please add some portfolios by going back to Dashboard > Portfolio first.', 'intensely' ) .' </div>',
		'priority'    		=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_portfolio_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),		
	) );
	
	// title
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'text',
		'settings' 			=> 'intensely_portfolio_title',
		'label'    			=> __( 'Title', 'intensely' ),
		'section'  			=> 'intensely_portfolio_section',
		'default'  			=> '',
		'priority' 			=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_portfolio_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '#portfolio .title-area .title',
                'function' 		=> 'html',
            ),
        ),				
	) );
	
	// Portfolio description
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'textarea',
		'settings' 			=> 'intensely_portfolio_desc',
		'label'    			=> __( 'Description', 'intensely' ),
		'section'  			=> 'intensely_portfolio_section',
		'default'  			=> '',
		'priority' 			=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_portfolio_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '#portfolio .title-area p',
                'function' 		=> 'html',
            ),
        ),				
	) );
	
	// portfolio count
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'number',
		'settings'    		=> 'intensely_portfolio_display_count',
		'label'       		=> __( 'How many portfolios you want to display?', 'intensely' ),
		'section'     		=> 'intensely_portfolio_section',
		'default'     		=> 4,
		'choices'     		=> array(
			'min'  => 1,
			'max'  => 999,
			'step' => 1,
		),
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_portfolio_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),		
	) );
	
	// Display order
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        => 'select',
		'settings'    => 'intensely_portfolio_display_order',
		'label'       => __( 'Display Order', 'intensely' ),
		'section'     => 'intensely_portfolio_section',
		'default'     => 'DESC',
		'priority'    => 10,
		'multiple'    => 1,
		'choices'     => array(
			'DESC' 	=> esc_attr__( 'New to old', 'intensely' ),
			'ASC' 	=> esc_attr__( 'Old to new', 'intensely' ),
		),
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_portfolio_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),		
	) );