<?php
/*
 *	This file contains featured slider section & fields
 *	
 *	@version 1.0
 *	@since intensely 1.0
 */	
	/*
	 *	Section -- Slider | Front Page
	 *
	 *	@since intensely 1.0
	 */
	 
	intensely_Kirki::add_section( 'intensely_slider_section', array(
	    'title'          => __( 'Featured Slider', 'intensely' ),
	    'priority'       => 10,
	    'panel'       	 => 'intensely_front_page_panel',
	    'capability'     => 'edit_theme_options',
	) );

	// slider enable/disable
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        => 'switch',
		'settings'    => 'intensely_featured_slider',
		'label'       => __( 'Slider on/off', 'intensely' ),
		'section'     => 'intensely_slider_section',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => array(
			'on'  => esc_attr__( 'Enable', 'intensely' ),
			'off' => esc_attr__( 'Disable', 'intensely' ),
		),
	) );
	
	/*
	 *	Fields -- slides | slider
	 *	Fields	-	Repeater ( Slide background image | Slide Image | Title | Description | Button Text | Button Link | Button Target ) |
	 				
	 *	@since intensely 1.0
	 */
		 
    intensely_Kirki::add_field( 'intensely_config', array(
        'type'        	=> 'repeater',
        'label'       	=> __( 'Add Slides', 'intensely' ),
        'settings'    	=> 'intensely_slide_option',		        
        'priority'    	=> 10,
        'section'     	=> 'intensely_slider_section',        
        'default'     	=> array(),
		'row_label' 	=> array(               
	        'type' 	=> 'text',
	        'value' => esc_attr__( 'slide', 'intensely' ),
		),
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_featured_slider',
				'operator' 		=> '==',
				'value'    		=> '1',
			),
		),	
        'fields' 		=> array(
                'intensely_slide_bg_image'  => array(
                'type'                  	=> 'image',
                'label'                 	=> esc_attr__( 'Upload background image', 'intensely' ),
                'description' 				=> esc_attr__( 'Best image size: 1280x620', 'intensely' ),
                'default'               	=> '',
            ),
                'intensely_slide_image' 	=> array(
                'type'                  	=> 'image',
                'label'                 	=> esc_attr__( 'Upload slide image', 'intensely' ),
				'description' 				=> esc_attr__( 'Best image size: 550x765', 'intensely' ),
                'default'               	=> '',
            ),
                'intensely_slide_text'         	=> array(
                'type'                  	=> 'text',
                'label'                 	=> esc_attr__( 'Slide title', 'intensely' ),
                'default'               	=> '',
            ),
                'intensely_slide_short_desc'   	=> array(
                'type'                  	=> 'textarea',
                'label'                 	=> esc_attr__( 'Slide short description', 'intensely' ),
                'default'               	=> '',
            ),
                'intensely_slide_button_text'  	=> array(
                'type'                  	=> 'text',
                'label'                 	=> esc_attr__( 'Button text', 'intensely' ),
                'default'               	=> '',
            ),
                'intensely_slide_button_link'  	=> array(
                'type'                  	=> 'text',
                'label'                 	=> esc_attr__( 'Button link', 'intensely' ),
                'default'               	=> '',
            ),
                'intensely_slide_button_target'	=> array(
                'type'                  	=> 'checkbox',
                'label'                 	=> esc_attr__( 'Check to open in a new tab', 'intensely' ),
                'default'               	=> false,
            ),                                                           
        ),
    ) );
	
	// main slide speed
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        => 'slider',
		'settings'    => 'intensely_main_slide_speed',
		'label'       => __( 'Slide speed (ms)', 'intensely' ),
		'section'     => 'intensely_slider_section',
		'default'     => 3000,
		'choices'     => array(
			'min'  => '3000',
			'max'  => '100000',
			'step' => '1000',
		),
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_featured_slider',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),		
	) );
	
	// main slide autoplay
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'checkbox',
		'settings' 			=> 'intensely_main_slide_autoplay_on_off',
		'label'    			=> __( 'Disable slide autoplay', 'intensely' ),
		'section'  			=> 'intensely_slider_section',
		'priority' 			=> 10,
		'default'     		=> '0',
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_featured_slider',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),				
	) );	
	
	// main slide dot nav	
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'checkbox',
		'settings' 			=> 'intensely_main_slide_dot_nav',
		'label'    			=> __( 'Disable slide dot nav', 'intensely' ),
		'section'  			=> 'intensely_slider_section',
		'priority' 			=> 10,
		'default'     		=> '0',
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_featured_slider',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),				
	) );
	// main slide arrow nav	
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'checkbox',
		'settings' 			=> 'intensely_main_slide_arrow_nav',
		'label'    			=> __( 'Disable slide arrow nav', 'intensely' ),
		'section'  			=> 'intensely_slider_section',
		'priority' 			=> 10,
		'default'     		=> '0',
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_featured_slider',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),				
	) );