<?php
/*
 *	This file contains "Numeric Counter" section & fields 
 *	
 *	@version 1.0
 *	@since intensely 1.0
 */
 
  	/*
	 *	Section -- Counter | Front Page
	 *
	 *	@since intensely 1.0
	 */
	 
	intensely_Kirki::add_section( 'intensely_counter_section', array(
	    'title'          	=> __( 'Counter', 'intensely' ),
	    'priority'       	=> 10,
	    'panel'       	 	=> 'intensely_front_page_panel',
	    'capability'     	=> 'edit_theme_options',
	) );
	
	
	/*
	 *	Fields -- Counter | Numeric Counter
	 *	Fields - Repeater Field ( icon | count number | count text ) | Image |
	 *			 background size | overlay color
	 *
	 *	@since intensely 1.0
	 */
	 
	// enable/disable
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'switch',
		'settings'    		=> 'intensely_counter_enable_disable',
		'label'       		=> __( 'Enable or disable Counter section', 'intensely' ),		
		'section'     		=> 'intensely_counter_section',
		'default'     		=> '1',
		'priority'    		=> 10,
		'choices'     		=> array(
			'on'  				=> esc_attr__( 'Enable', 'intensely' ),
			'off' 				=> esc_attr__( 'Disable', 'intensely' ),
		),
	) );
	
	// counters
    intensely_Kirki::add_field( 'intensely_config', array(
        'type'        		=> 'repeater',
        'settings'    		=> 'intensely_counter_option',        
        'label'       		=> __( 'Add Counters', 'intensely' ),
        'section'     		=> 'intensely_counter_section',				        
        'priority'    		=> 10,
        'default'     		=> array(),
        'row_label' 		=> array(               
	        'type' 							=> 'text',
	        'value' 						=> esc_attr__( 'counter', 'intensely' ),
		),
		'active_callback'   => array(
			array(
				'setting'  					=> 'intensely_counter_enable_disable',
				'operator' 					=> '==',
				'value'    					=> 1,
			),
		),		        
        'fields' 			=> array(
                'intensely_counter_icon'    => array(
                'type'                  	=> 'select',
                'label'                 	=> esc_attr__( 'Icon', 'intensely' ),
                'choices'     				=> intensely_font_awesome(),                
                'default'               	=> '',               
            ),
                'intensely_counter_number'  => array(
                'type'                  	=> 'text',
                'label'                 	=> esc_attr__( 'Count number', 'intensely' ),
                'default'               	=> '',
            ),
                'intensely_counter_text'  	=> array(
                'type'                  	=> 'text',
                'label'                 	=> esc_attr__( 'Count text', 'intensely' ),
                'default'               	=> '',
            ),                                                          
        )
    ) );
	 
    // background image
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'image',
		'settings'    		=> 'intensely_counter_bg_image',
		'label'       		=> __( 'Background Image', 'intensely' ),
		'section'     		=> 'intensely_counter_section',
		'default'     		=> '',
		'priority'    		=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_counter_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),			
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '#counter',
                'function' 		=> 'css',
                'property' 		=> 'background-image',
            ),
        ),			
	) );
	
	// background size
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'select',
		'settings'    		=> 'intensely_counter_bg_size',
		'label'       		=> __( 'Background size', 'intensely' ),
		'section'     		=> 'intensely_counter_section',
		'default'     		=> 'cover',
		'priority'    		=> 10,
		'multiple'    		=> 1,
		'choices'     		=> array(
			'cover' 			=> esc_attr__( 'cover', 'intensely' ),
			'contain' 			=> esc_attr__( 'contain', 'intensely' ),
			'initial' 			=> esc_attr__( 'initial', 'intensely' ),
		),
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_counter_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),			
		),		
	) );
	
	// background repeat
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'select',
		'settings'    		=> 'intensely_counter_bg_repeat',
		'label'       		=> __( 'Background repeat', 'intensely' ),
		'section'     		=> 'intensely_counter_section',
		'default'     		=> 'no-repeat',
		'priority'    		=> 10,
		'multiple'    		=> 1,
		'choices'     		=> array(
			'repeat' 			=> esc_attr__( 'Repeat', 'intensely' ),
			'repeat-x' 			=> esc_attr__( 'Repeat X', 'intensely' ),
			'repeat-y' 			=> esc_attr__( 'Repeat Y', 'intensely' ),
			'no-repeat' 		=> esc_attr__( 'No Repeat', 'intensely' ),
		),
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_counter_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),			
		),		
	) );		
	
	// background overlay color	 	
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'color',
		'settings'    		=> 'intensely_counter_bg_color',
		'label'       		=> __( 'Background overlay', 'intensely' ),
		'section'     		=> 'intensely_counter_section',
		'default'     		=> 'rgba(15, 22, 30, 0.5)',
		'priority'    		=> 10,
		'alpha'       		=> true,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_counter_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),			
		),		
		'transport'   		=> 'auto',
        'output'      		=> array(
            array(
                'element'  		=> '.counter-overlay',
                'property' 		=> 'background-color',
            ),
        ),					
	) );