<?php
/*
 *	This file contains "Clients Logo" section & fields 
 *	
 *	@version 1.0
 *	@since intensely 1.0
 */
 
  	/*
	 *	Section -- Client's logo | Front Page
	 *
	 *	@since intensely 1.0
	 */
	 
	intensely_Kirki::add_section( 'intensely_clients_logo_section', array(
	    'title'          	=> __( 'Clients Logo', 'intensely' ),
	    'priority'       	=> 10,
	    'panel'       	 	=> 'intensely_front_page_panel',
	    'capability'     	=> 'edit_theme_options',
	) );
	
	
	/*
	 *	Fields -- clients logo
	 *	Fields - Enable,Disable | Repeater Field ( Image )
	 *
	 *	@since intensely 1.0
	 */
	 
	// enable/disable
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'switch',
		'settings'    		=> 'intensely_clients_logo_enable_disable',
		'label'       		=> __( 'Enable or disable clients logo section', 'intensely' ),		
		'section'     		=> 'intensely_clients_logo_section',
		'default'     		=> '1',
		'priority'    		=> 10,
		'choices'     		=> array(
			'on'  				=> esc_attr__( 'Enable', 'intensely' ),
			'off' 				=> esc_attr__( 'Disable', 'intensely' ),
		),
	) );	
	
	// logo
    intensely_Kirki::add_field( 'intensely_config', array(
        'type'        		=> 'repeater',
        'settings'    		=> 'intensely_clients_logo_option',        
        'label'       		=> __( 'Add logos', 'intensely' ),
        'section'     		=> 'intensely_clients_logo_section',				        
        'priority'    		=> 10,
        'default'     		=> array(),
        'row_label' 		=> array(               
	        'type' 				=> 'text',
	        'value' 			=> esc_attr__( 'logo', 'intensely' ),
		),
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_clients_logo_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),		        
        'fields' 			=> array(
                'intensley_cl_image'   	=> array(
                'type'           		=> 'image',
                'label'          		=> esc_attr__( 'Image', 'intensely' ),
                'description' 	 		=> esc_attr__( 'Best image size is: 124x27', 'intensely' ),
                'default'        		=> '',                
            ),                                                                                                          
        )
    ) );
    
	// clients logo slide amount
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'slider',
		'settings'    		=> 'intensely_clients_logo_slide_amount',
		'label'       		=> __( 'How many logo you want to dsiplay?', 'intensely' ),
		'section'     		=> 'intensely_clients_logo_section',
		'default'     		=> 4,
		'choices'     		=> array(
			'min'  => '1',
			'max'  => '999',
			'step' => '1',
		),
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_clients_logo_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),		
	) );    

	// clients logo slide autoplay
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'checkbox',
		'settings' 			=> 'intensely_clients_logo_autoplay_on_off',
		'label'    			=> __( 'Disable slide autoplay', 'intensely' ),
		'section'  			=> 'intensely_clients_logo_section',
		'priority' 			=> 10,
		'default'     		=> '0',
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_clients_logo_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),				
	) );    