<?php
/*
 *	This file contains "Blog" section & fields 
 *	
 *	@version 1.0
 *	@since intensely 1.0
 */
 
	/*
	 *	Section -- Blog | Front Page
	 *
	 *	@since intensely 1.0
	 */
	 
	intensely_Kirki::add_section( 'intensely_home_blog_section', array(
	    'title'          => __( 'Blog', 'intensely' ),
	    'priority'       => 10,
	    'panel'       	 => 'intensely_front_page_panel',
	    'capability'     => 'edit_theme_options',
	) );
	

	/*
	 *	Fields -- Blog
	 *	Fields - Switch | Title | Description | Post count | enable/disable options
	 *
	 *	@since intensely 1.0
	 */
	
	// enable/disable	
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'switch',
		'settings'    		=> 'intensely_home_blog_enable_disable',
		'label'       		=> __( 'Enable or disable Blog section', 'intensely' ),		
		'section'     		=> 'intensely_home_blog_section',
		'default'     		=> '1',
		'priority'    		=> 10,
		'choices'     		=> array(
			'on'  => esc_attr__( 'Enable', 'intensely' ),
			'off' => esc_attr__( 'Disable', 'intensely' ),
		),
	) );
	
	// title
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'text',
		'settings' 			=> 'intensely_home_blog_title',
		'label'    			=> __( 'Title', 'intensely' ),
		'section'  			=> 'intensely_home_blog_section',
		'default'  			=> '',
		'priority' 			=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_home_blog_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '#latest-news .title-area .title',
                'function' 		=> 'html',
            ),
        ),				
	) );
	
	// Description
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'textarea',
		'settings' 			=> 'intensely_home_blog_desc',
		'label'    			=> __( 'Description', 'intensely' ),
		'section'  			=> 'intensely_home_blog_section',
		'default'  			=> '',
		'priority' 			=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_home_blog_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '#latest-news .title-area p',
                'function' 		=> 'html',
            ),
        ),				
	) );
	
	// post count
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'number',
		'settings'    		=> 'intensely_home_blog_post_count',
		'label'       		=> __( 'How many posts you want to display?', 'intensely' ),
		'section'     		=> 'intensely_home_blog_section',
		'default'     		=> 3,
		'choices'     		=> array(
			'min'  => 1,
			'max'  => 30,
			'step' => 1,
		),
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_home_blog_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),		
	) );
	
	// Display order
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        => 'select',
		'settings'    => 'intensely_home_posts_display_order',
		'label'       => __( 'Display Order', 'intensely' ),
		'section'     => 'intensely_home_blog_section',
		'default'     => 'DESC',
		'priority'    => 10,
		'multiple'    => 1,
		'choices'     => array(
			'DESC' 	=> esc_attr__( 'New to old', 'intensely' ),
			'ASC' 	=> esc_attr__( 'Old to new', 'intensely' ),
			'ASC' 	=> esc_attr__( 'Old to new', 'intensely' ),
		),
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_home_blog_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),		
	) );