<?php
/*
 *	This file contains "About" section & fields 
 *	
 *	@version 1.0
 *	@since intensely 1.0
 */
 
 	/*
	 *	Section -- About | Front Page
	 *
	 *	@since intensely 1.0
	 */
	 
	intensely_Kirki::add_section( 'intensely_about_section', array(
	    'title'          	=> __( 'About', 'intensely' ),
	    'priority'       	=> 10,
	    'panel'       	 	=> 'intensely_front_page_panel',
	    'capability'     	=> 'edit_theme_options',
	) );
	
	/*
	 *	Fields -- About | About Area
	 *	Fields - Image | Retina Image | Title | Descritpion | Button Text | Button Link
	 *
	 *	@since intensely 1.0
	 */
	
	// enable/disable	
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'switch',
		'settings'    		=> 'intensely_about_enable_disable',
		'label'       		=> __( 'Enable or disable About section', 'intensely' ),		
		'section'     		=> 'intensely_about_section',
		'default'     		=> '1',
		'priority'    		=> 10,
		'choices'     		=> array(
			'on'  => esc_attr__( 'Enable', 'intensely' ),
			'off' => esc_attr__( 'Disable', 'intensely' ),
		),
	) );
	
	// section title
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'text',
		'settings' 			=> 'intensely_about_title',
		'label'    			=> __( 'Section Title', 'intensely' ),
		'section'  			=> 'intensely_about_section',
		'default'  			=> '',
		'priority' 			=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_about_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '#about .title-area .title',
                'function' 		=> 'html',
            ),
        ),				
	) );
	
	// section short description
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'textarea',
		'settings' 			=> 'intensely_about_desc',
		'label'    			=> __( 'Section Description', 'intensely' ),
		'section'  			=> 'intensely_about_section',
		'default'  			=> '',
		'priority' 			=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_about_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '#about .title-area p',
                'function' 		=> 'html',
            ),
        ),				
	) );
	
	// progress bar title
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'text',
		'settings' 			=> 'intensely_about_progressbar_title',
		'label'    			=> __( 'Progress bar Title', 'intensely' ),
		'section'  			=> 'intensely_about_section',
		'default'  			=> '',
		'priority' 			=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_about_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '.about-content .our-skill h3',
                'function' 		=> 'html',
            ),
        ),				
	) );
	
	// progress bar description
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'textarea',
		'settings' 			=> 'intensely_about_progressbar_desc',
		'label'    			=> __( 'Progress bar description', 'intensely' ),
		'section'  			=> 'intensely_about_section',
		'default'  			=> '',
		'priority' 			=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_about_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '.about-content .our-skill-content > p',
                'function' 		=> 'html',
            ),
        ),				
	) );
	// progress bar
    intensely_Kirki::add_field( 'intensely_config', array(
        'type'        	=> 'repeater',
        'label'       	=> __( 'Add Progress Bars', 'intensely' ),
        'settings'    	=> 'intensely_about_progressbar_option',		        
        'priority'    	=> 10,
        'section'     	=> 'intensely_about_section',        
        'default'     	=> array(),
		'row_label' 	=> array(               
	        'type' 	=> 'text',
	        'value' => esc_attr__( 'bar', 'intensely' ),
		),
        'fields' 		=> array(
                'intensely_progressbar_name'  	=> array(
                'type'                  		=> 'text',
                'label'                 		=> esc_attr__( 'Bar text.', 'intensely' ),
                'description'                  	=> esc_attr__( 'Your skill name, Ex: Photoshop', 'intensely' ),
                'default'               		=> '',
            ),
                'intensely_progressbar_value'  	=> array(
                'type'                  		=> 'text',
                'label'                 		=> esc_attr__( 'Bar value', 'intensely' ),
                'description'                  	=> esc_attr__( 'Ex: 70', 'intensely' ),
                'default'               		=> '',
            ),                                                          
        ),
    ) );
	// Accordion title
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'text',
		'settings' 			=> 'intensely_about_accordion_title',
		'label'    			=> __( 'Accordion Title', 'intensely' ),
		'section'  			=> 'intensely_about_section',
		'default'  			=> '',
		'priority' 			=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_about_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '.about-content .why-choose-us h3',
                'function' 		=> 'html',
            ),
        ),				
	) );
	// Accordions bar
    intensely_Kirki::add_field( 'intensely_config', array(
        'type'        	=> 'repeater',
        'label'       	=> __( 'Add Accordions', 'intensely' ),
        'description'   => __( 'You could add max: 10 accordions', 'intensely' ),
        'settings'    	=> 'intensely_about_accordion_option',		        
        'priority'    	=> 10,
        'section'     	=> 'intensely_about_section', 
        'default'     	=> array(),
		'row_label' 	=> array(
	        'type' 	=> 'text',
	        'value' => esc_attr__( 'accordion', 'intensely' ),
		),
        'fields' 		=> array(
                'intensely_accordion_title'  	=> array(
                'type'                  		=> 'text',
                'label'                 		=> esc_attr__( 'Title', 'intensely' ),
                'default'               		=> '',
            ),
                'intensely_accordion_desc'  	=> array(
                'type'                  		=> 'textarea',
                'label'                 		=> esc_attr__( 'Description', 'intensely' ),
                'default'               		=> '',
            ),                                                          
        ),
    ) );
    
	// skill enable/disable
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'checkbox',
		'settings' 			=> 'intensely_about_skill',
		'label'    			=> __( 'Check to hide skills section', 'intensely' ),
		'section'  			=> 'intensely_about_section',
		'priority' 			=> 10,
		'default'     		=> '0',		
	) );
	
	// accordion enable/disable
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'checkbox',
		'settings' 			=> 'intensely_about_accordion',
		'label'    			=> __( 'Check to hide accordion section', 'intensely' ),
		'section'  			=> 'intensely_about_section',
		'priority' 			=> 10,
		'default'     		=> '0',		
	) );