<?php
/*
 *	This file contains "Footer" section & fields 
 *	
 *	@version 1.0
 *	@since intensely 1.0
 */
	
	/*
	 *	Section -- Footer
	 *
	 *	@since intensely 1.0
	 */	 	
	intensely_Kirki::add_panel( 'intensely_footer_panel', array(
	    'priority'    => 10,
	    'title'       => esc_attr__( 'Footer', 'intensely' ),
	) );
	
	/*
	 *	Subscribe section
	 */
	intensely_Kirki::add_section( 'intensely_subscribe_section', array(
	    'title'          	=> __( 'Subscribe', 'intensely' ),
	    'priority'       	=> 10,
	    'panel'       	 	=> 'intensely_footer_panel',
	    'capability'     	=> 'edit_theme_options',
	) );
	// Footer subscription enable/disable
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'checkbox',
		'settings' 			=> 'intensely_footer_subscribe',
		'label'    			=> __( 'Check to hide subscription section.', 'intensely' ),
		'section'  			=> 'intensely_subscribe_section',
		'priority' 			=> 10,
		'default'     		=> '0',		
	) );
    // background image
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'image',
		'settings'    		=> 'intensely_subscribe_bg_image',
		'label'       		=> __( 'Background Image', 'intensely' ),
		'section'     		=> 'intensely_subscribe_section',
		'default'     		=> '',
		'priority'    		=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_footer_subscribe',
				'operator' 		=> '==',
				'value'    		=> 0,
			),			
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '#subscribe',
                'function' 		=> 'css',
                'property' 		=> 'background-image',
            ),
        ),			
	) );
	
	// background size
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'select',
		'settings'    		=> 'intensely_subscribe_bg_size',
		'label'       		=> __( 'Background size', 'intensely' ),
		'section'     		=> 'intensely_subscribe_section',
		'default'     		=> 'cover',
		'priority'    		=> 10,
		'multiple'    		=> 1,
		'choices'     		=> array(
			'cover' 			=> esc_attr__( 'cover', 'intensely' ),
			'contain' 			=> esc_attr__( 'contain', 'intensely' ),
			'initial' 			=> esc_attr__( 'initial', 'intensely' ),
		),
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_footer_subscribe',
				'operator' 		=> '==',
				'value'    		=> 0,
			),			
		),		
	) );
	
	// background repeat
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'select',
		'settings'    		=> 'intensely_subscribe_bg_repeat',
		'label'       		=> __( 'Background repeat', 'intensely' ),
		'section'     		=> 'intensely_subscribe_section',
		'default'     		=> 'no-repeat',
		'priority'    		=> 10,
		'multiple'    		=> 1,
		'choices'     		=> array(
			'repeat' 			=> esc_attr__( 'Repeat', 'intensely' ),
			'repeat-x' 			=> esc_attr__( 'Repeat X', 'intensely' ),
			'repeat-y' 			=> esc_attr__( 'Repeat Y', 'intensely' ),
			'no-repeat' 		=> esc_attr__( 'No Repeat', 'intensely' ),
		),
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_footer_subscribe',
				'operator' 		=> '==',
				'value'    		=> 0,
			),			
		),		
	) );
	// background overlay color	 	
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'color',
		'settings'    		=> 'intensely_subscribe_bg_color',
		'label'       		=> __( 'Background overlay', 'intensely' ),
		'section'     		=> 'intensely_subscribe_section',
		'default'     		=> 'rgba(0,0,0,0.6)',
		'priority'    		=> 10,
		'alpha'       		=> true,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_footer_subscribe',
				'operator' 		=> '==',
				'value'    		=> 0,
			),			
		),		
		'transport'   		=> 'auto',
        'output'      		=> array(
            array(
                'element'  		=> '.subscribe-overlay',
                'property' 		=> 'background-color',
            ),
        ),					
	) );
	// Subscribe title
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'text',
		'settings' 			=> 'intensely_subscribe_title',
		'label'    			=> __( 'Subscribe title', 'intensely' ),
		'section'  			=> 'intensely_subscribe_section',
		'priority' 			=> 10,
		'default'     		=> '',
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '.subscribe-area h2',
                'function' 		=> 'html',
            ),
        ),
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_footer_subscribe',
				'operator' 		=> '==',
				'value'    		=> 0,
			),			
		),	
	) );
	// Subscribe shortcode
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'text',
		'settings' 			=> 'intensely_subscribe_shortcode',
		'label'    			=> __( 'Subscribe shortcode', 'intensely' ),
		'description'    	=> __( 'Put your Mailchimp for wp plugin subscription form shortcode. Dashboard > MailChimp for WP > Forms', 'intensely' ),
		'section'  			=> 'intensely_subscribe_section',
		'priority' 			=> 10,
		'default'     		=> '',
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_footer_subscribe',
				'operator' 		=> '==',
				'value'    		=> 0,
			),			
		),
	) );
	
	/*
	 *	Footer section
	 */
	intensely_Kirki::add_section( 'intensely_footer_section', array(
	    'title'          	=> __( 'Footer', 'intensely' ),
	    'priority'       	=> 10,
	    'panel'       	 	=> 'intensely_footer_panel',
	    'capability'     	=> 'edit_theme_options',
	) );
	// Footer bottom enable/disable
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'checkbox',
		'settings' 			=> 'intensely_footer_bottom',
		'label'    			=> __( 'Check to hide footer bottom.', 'intensely' ),
		'section'  			=> 'intensely_footer_section',
		'priority' 			=> 10,
		'default'     		=> '0',		
	) );
	// Footer text
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'text',
		'settings' 			=> 'intensely_footer_bottom_text',
		'label'    			=> __( 'Footer Text', 'intensely' ),
		'section'  			=> 'intensely_footer_section',
		'priority' 			=> 10,
		'default'     		=> '',
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '.footer-left p',
                'function' 		=> 'html',
            ),
        ),	
	) );
	// Footer link text
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'text',
		'settings' 			=> 'intensely_footer_bottom_link_text',
		'label'    			=> __( 'Footer Link Text', 'intensely' ),
		'section'  			=> 'intensely_footer_section',
		'priority' 			=> 10,
		'default'     		=> '',	
	) );
	// Footer link text
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'text',
		'settings' 			=> 'intensely_footer_bottom_link_url',
		'label'    			=> __( 'Footer Link', 'intensely' ),
		'section'  			=> 'intensely_footer_section',
		'priority' 			=> 10,
		'default'     		=> '',	
	) );