<?php
/*
 *	This file contains theme customizer settings.
 *	All these setting options created using kirki 
 * 	@link https://github.com/aristath/kirki
 *
 *	@version 1.0
 *	@since intensely 1.0
 */	

/*
 *	Add Kirki helper class
 *	@link https://github.com/aristath/kirki-helpers
 *
 *	@since intensely 1.0
 */
 require_once( get_template_directory() . '/inc/functions/customizer/intensely-kirki.php' );

/*  
 *	Font-awesome icon classes for customizer
 *
 *	@since intensely 1.0
 */ 
require_once( get_template_directory() . '/inc/functions/customizer/font-awesome-icons.php' ); 

/*
 *	Register customizer options
 *
 *	@since intensely 1.0
 */
function intensely_customizer_register( $wp_customize ) {

	/*
	 * set paths
	 *
	 * @since intensely 1.0
	 */
	$customizer_path = '/inc/functions/customizer';
	
	/*  
	 *
	 *	body background color
	 *	set to postMessage by default
	 *
	 *	@since intensely 1.0
	 */	
	$wp_customize->get_setting( 'background_color' )->transport = 'postMessage';	
	
	/*  
	 *
	 *	Customizer configuration setting.
	 *	Used globally for all fields.
	 *
	 *	options type - theme-mod
	 *
	 *	@since intensely 1.0
	 */
	require_once( get_template_directory() . $customizer_path . '/config.php' );

	/*  
	 *
	 *	Theme Info - Sections, fields
	 *
	 *	@since intensely 1.0
	 */
	require_once( get_template_directory() . $customizer_path . '/theme-info.php' );
	
	/*  
	 *
	 *	General Settings - Sections, fields
	 *
	 *	@since intensely 1.0
	 */
	require_once( get_template_directory() . $customizer_path . '/general-settings.php' );
	
	/*  
	 *
	 *	Header - Sections, fields
	 *
	 *	@since intensely 1.0
	 */
	require_once( get_template_directory() . $customizer_path . '/header.php' );
	
	/*  
	 *
	 *	Frontpage - Sections, fields
	 *
	 *	@since intensely 1.0
	 */
	require_once( get_template_directory() . $customizer_path . '/front-page.php' );
	
	/*  
	 *
	 *	Frontpage - Sections, fields
	 *
	 *	@since intensely 1.0
	 */
	require_once( get_template_directory() . $customizer_path . '/blog.php' );
	
	/*  
	 *
	 *	Header - Sections, fields
	 *
	 *	@since intensely 1.0
	 */
	require_once( get_template_directory() . $customizer_path . '/contact.php' );
	
	/*  
	 *
	 *	Section/Fields - footer
	 *	Contains "footer" section & fields.
	 *
	 *	@since intensely 1.0
	 */
	require_once( get_template_directory() . $customizer_path . '/footer.php' );
	
	/*  
	 *
	 *	Section/Fields - 404 
	 *	Contains "404" section & fields.
	 *
	 *	@since intensely 1.0
	 */
	require_once( get_template_directory() . $customizer_path . '/404.php' );										
	 		
   
}
add_action( 'customize_register', 'intensely_customizer_register' );

/*
 *	Text field validation for URL field for repeater field group 
 *	
 *	@since intensely 1.0
 */
function intensely_sanitize_customizer( $value ) {

    if ( !is_array( $value ) ) {
        $value = array();
    }
	
	// featured slider
    foreach ( $value['intensely_slide_option'] as $key => $subvalue ) {
		
		// slide url
        if ( isset( $value['intensely_slide_option'][ $key ]['intensely_slide_button_link'] ) ) {
            $value['intensely_slide_option'][ $key ]['intensely_slide_button_link'] = esc_url_raw( $value['intensely_slide_option'][ $key ]['intensely_slide_button_link'] );
        }

    }
	// pricing table button url
    foreach ( $value['intensely_pricing_option'] as $key => $subvalue ) {
		
		// table button url
        if ( isset( $value['intensely_pricing_option'][ $key ]['intensely_pricing_table_button_url'] ) ) {
            $value['intensely_pricing_option'][ $key ]['intensely_pricing_table_button_url'] = esc_url_raw( $value['intensely_pricing_option'][ $key ]['intensely_pricing_table_button_url'] );
        }

    }
    
    return $value;

}
add_action( 'sanitize_option_theme_mods_intensely', 'intensely_sanitize_customizer' );