<?php
/*
 *	This file contains "contact page" panel, section & fields.
 *
 *	@version 1.0
 *	@since intensely 1.0
 */
	/*
	 *	Panel -- contact
	 *
	 *  @since intensely 1.0
	 */	 	
	intensely_Kirki::add_panel( 'intensely_contact_page_panel', array(
	    'priority'    => 10,
	    'title'       => esc_attr__( 'Contact', 'intensely' ),
	) );
	
 	/*
	 *	Section -- Contact info | Contact Page
	 *
	 *	@since intensely 1.0
	 */
	 
	intensely_Kirki::add_section( 'intensely_contact_info_section', array(
	    'title'          	=> __( 'Contact info', 'intensely' ),
	    'priority'       	=> 10,
	    'panel'       	 	=> 'intensely_contact_page_panel',
	    'capability'     	=> 'edit_theme_options',
	) );
	
	// enable/disable	
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'        		=> 'switch',
		'settings'    		=> 'intensely_contact_info_enable_disable',
		'label'       		=> __( 'Enable or disable contact info section', 'intensely' ),		
		'section'     		=> 'intensely_contact_info_section',
		'default'     		=> '1',
		'priority'    		=> 10,
		'choices'     		=> array(
			'on'  => esc_attr__( 'Enable', 'intensely' ),
			'off' => esc_attr__( 'Disable', 'intensely' ),
		),
	) );
	
	// section title
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'text',
		'settings' 			=> 'intensely_contact_info_section_title',
		'label'    			=> __( 'Title', 'intensely' ),
		'section'  			=> 'intensely_contact_info_section',
		'default'  			=> '',
		'priority' 			=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_contact_info_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '#contact .title-area .title',
                'function' 		=> 'html',
            ),
        ),				
	) );
	
	// section description
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'textarea',
		'settings' 			=> 'intensely_contact_info_section_desc',
		'label'    			=> __( 'Description', 'intensely' ),
		'section'  			=> 'intensely_contact_info_section',
		'default'  			=> '',
		'priority' 			=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_contact_info_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '#contact .title-area p',
                'function' 		=> 'html',
            ),
        ),				
	) );
	
	// contact info title
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'text',
		'settings' 			=> 'intensely_contact_info_title',
		'label'    			=> __( 'Contact info title', 'intensely' ),
		'section'  			=> 'intensely_contact_info_section',
		'default'  			=> __( 'Contact info', 'intensely' ),
		'priority' 			=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_contact_info_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '#contact .contact-area-left h4',
                'function' 		=> 'html',
            ),
        ),				
	) );
	
	// contact info
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'textarea',
		'settings' 			=> 'intensely_contact_info_desc',
		'label'    			=> __( 'Contact info', 'intensely' ),
		'section'  			=> 'intensely_contact_info_section',
		'default'  			=> '',
		'priority' 			=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_contact_info_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '#contact .contact-area-left p',
                'function' 		=> 'html',
            ),
        ),				
	) );
	
	// contact form shortcode
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'textarea',
		'settings' 			=> 'intensely_contact_form_shortcode',
		'label'    			=> __( 'Contact form shortcode', 'intensely' ),
		'description'    	=> __( 'Put your contact form 7 shortcode here. Go to Dashboard > Contact', 'intensely' ),
		'section'  			=> 'intensely_contact_info_section',
		'default'  			=> '',
		'priority' 			=> 10,
		'active_callback'   => array(
			array(
				'setting'  		=> 'intensely_contact_info_enable_disable',
				'operator' 		=> '==',
				'value'    		=> 1,
			),
		),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '#contact .contact-area-left h4',
                'function' 		=> 'html',
            ),
        ),				
	) );
	
 	/*
	 *	Section -- Google map | Contact Page
	 *
	 *	@since intensely 1.0
	 */
	intensely_Kirki::add_section( 'intensely_google_map_section', array(
	    'title'          	=> __( 'Google map', 'intensely' ),
	    'priority'       	=> 10,
	    'panel'       	 	=> 'intensely_contact_page_panel',
	    'capability'     	=> 'edit_theme_options',
	) );
	
	// Google map embed field
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'code',
		'settings' 			=> 'intensely_google_map_embed',
		'label'    			=> __( 'Google map embed code', 'intensely' ),
		'description'    	=> __( 'Put your Google map embed code here.', 'intensely' ),
		'section'  			=> 'intensely_google_map_section',
		'default'  			=> '',
		'priority' 			=> 10,
		'choices'     		=> array(
			'language' => 'html',
			'theme'    => 'monokai',
			'height'   => 250,
		),				
	) );