<?php
/*
 *	This file contains "404 page" section & fields 
 *	
 *	@version 1.0
 *	@since intensely 1.0
 */
	
	/*
	 *	Section -- 404 page
	 *
	 *	@since intensely 1.0
	 */
	 
	intensely_Kirki::add_section( 'intensely_four_zero_four_section', array(
	    'title'          	=> __( '404 Page', 'intensely' ),
	    'priority'       	=> 10,
	    'capability'     	=> 'edit_theme_options',
	) );
	
	// 404 text
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'text',
		'settings' 			=> 'intensely_404_title_text',
		'label'    			=> __( '404 Text', 'intensely' ),
		'section'  			=> 'intensely_four_zero_four_section',
		'priority' 			=> 10,
		'default'     		=> __( 'Opps!', 'intensely' ),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '.error-content span',
                'function' 		=> 'html',
            ),
        ),				
	) );
	
	// 404 subtitle text
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'text',
		'settings' 			=> 'intensely_404_subtitle_text',
		'label'    			=> __( 'Subtitle Text', 'intensely' ),
		'section'  			=> 'intensely_four_zero_four_section',
		'priority' 			=> 10,
		'default'     		=> __( 'We\'re sorry, but the page you were looking for doesn\'t exist.', 'intensely' ),
        'transport'   		=> 'postMessage',
        'js_vars'     		=> array(
            array(
                'element'  		=> '.error-content p',
                'function' 		=> 'html',
            ),
        ),				
	) );
	
	// 404 button text
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'text',
		'settings' 			=> 'intensely_404_btn_text',
		'label'    			=> __( 'Button text', 'intensely' ),
		'section'  			=> 'intensely_four_zero_four_section',
		'priority' 			=> 10,
		'default'     		=> __( 'Home', 'intensely' ),				
	) );
	
	// 404 button url	
	intensely_Kirki::add_field( 'intensely_config', array(
		'type'     			=> 'text',
		'settings' 			=> 'intensely_404_btn_url',
		'label'    			=> __( 'Button URL', 'intensely' ),
		'section'  			=> 'intensely_four_zero_four_section',
		'sanitize_callback' => 'esc_url_raw',
		'default'     		=> home_url( '/' ),
		'priority' 			=> 10,		
	) );				