<?php
/**
 * The Header for intensely theme
 *
 * Displays all of the <head> section and everything up till header styles
 *
 * 	@package WordPress
 *	@version 1.0
 *	@since intensely 1.0
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> >
  <head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="//gmpg.org/xfn/11">
    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
  
	<?php wp_head(); ?>
  </head>
  <body <?php body_class(); ?> >

  	<?php
	  	$preloader	=	esc_html( get_theme_mod( 'intensely_preloaders_option', '1' ) );
	  	if( $preloader == false ):
  	?>
	 	<!-- BEGAIN PRELOADER -->
	    <div id="preloader">
	      <div id="status">&nbsp;</div>
	    </div>
		<!-- END PRELOADER -->
	<?php endif; ?>

  	<?php
	  	$preloader	=	esc_html( get_theme_mod( 'intensely_scroll_top', '0' ) );
	  	if( $preloader == '0' ):
  	?>
		<!-- SCROLL TOP BUTTON -->
	    <a class="scrollToTop" href="#"><i class="fa fa-angle-up"></i></a>
		<!-- END SCROLL TOP BUTTON -->
	<?php endif; ?>

   	<!-- Start header -->
  	<header id="header">
	    
	    <?php
		/*
		 *	Enable/disable search
		 *
		 *	@since intensely 1.0
		 */
		 $header_search		=	esc_html( get_theme_mod( 'intensely_header_bottom_search', '0' ) );
		 
		 if( $header_search == '0' ) : ?>
		    <!-- header top search -->
		    <div class="header-top">
		      	<div class="container">
			        <form role="search" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
				        <div id="search">
				          <input type="search" name="s" placeholder="<?php _e( 'Type your search keyword here and hit Enter...', 'intensely' ); ?>" name="s" id="m_search" style="display: inline-block;">
				          <input type="hidden" name="post_type" value="post"/> 
				          <button type="submit">
				          	<i class="fa fa-search"></i>
				          </button>
				        </div>
			        </form>
		      	</div>
		    </div>
	    <?php endif; ?>    
  	</header>
  	<!-- End header -->

	<!-- BEGIN MENU -->
  	<section id="menu-area">      
	    <nav class="navbar navbar-default" role="navigation">  
		    <div class="container">
		       
		        <div class="navbar-header">
					<!-- FOR MOBILE VIEW COLLAPSED BUTTON -->
					<button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
					<span class="sr-only"><?php _e( 'Toggle navigation', 'intensely' ); ?></span>
					<span class="icon-bar"></span>
					<span class="icon-bar"></span>
					<span class="icon-bar"></span>
					</button>
					
			      	<!-- Start Logo image/text -->
					<?php 
						if( function_exists( 'the_custom_logo' ) && has_custom_logo() ) :
						 
						$custom_logo_id 	= get_theme_mod( 'custom_logo' );
						$custom_logo 		= wp_get_attachment_image_src( $custom_logo_id , 'full' );		
					?>
						<!-- logo img -->
						<a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" >
							<img src="<?php echo $custom_logo[0]; ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" />
						</a>
			
					<?php else : ?>
					
						<!-- logo text -->				
						<a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" >
							<span><?php bloginfo( 'name', 'display' ); ?></span>
						</a>
						
					<?php endif; ?>				      
					<!-- End Logo image/text -->
					
		        </div>
		        
		        <div id="navbar" class="navbar-collapse collapse">
			        
			        <?php
						/* 
						 *	Primary Menu
						 */			
						wp_nav_menu( array(
						  'theme_location' 	=> 'intensely-primary-menu',
						  'depth' 			=> 2,
						  'container' 		=> false,
						  'menu_class' 		=> 'nav navbar-nav navbar-right main-nav',
						  'menu_id' 		=> 'top-menu',
						  'fallback_cb'       => '',
						  'walker' 			=> new wp_bootstrap_navwalker(),  //Process nav menu using custom nav walker
						  )
						);
			        ?>                   
		        </div><!--/.nav-collapse -->
		        
			    <?php
				/*
				 *	Enable/disable search
				 *
				 *	@since intensely 1.0
				 */
				 $header_search		=	esc_html( get_theme_mod( 'intensely_header_bottom_search', '0' ) );
				 
				 if( $header_search == '0' ) : ?>
			        <a href="#" id="search-icon">
			          <i class="fa fa-search"></i>
			        </a>
		        <?php endif; ?>
		        
		    </div>     
	    </nav>
  	</section>
  	<!-- END MENU --> 