<?php
/*
 *	functions for intensely theme
 *
 *	@file	functions.php
 *	@version 1.0
 *	@since intensely 1.0
 *	

/*
 *  Load after_setup_theme action hook.
 *
 *  Contains basic theme setup, registration such as menu, 
 *  thumbnail image, title, nav menus, content-width etc.
 */
require_once( 'inc/functions/after-theme-setup.php' );

 /*
  *  Load Bootstrap navwalker custom class
  *	
  *	 @link https://github.com/twittem/wp-bootstrap-navwalker
  */
require_once( 'inc/functions/wp_bootstrap_navwalker.php' );

 /**
  * Register widget area.
  *
  * @link https://codex.wordpress.org/Function_Reference/register_sidebar
  */
function intensely_widget_areas() {

	// Post sidebar
	register_sidebar( array(
		'name'          => __( 'Post Sidebar', 'intensely' ),
		'id'            => 'intensely-post-sidebar',
		'description'   => __( 'Add your desire widgets here. Widgets will appear in archive pages & post single.', 'intensely' ),
		'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="widgettitle widget-title">',
		'after_title'   => '</h3>',
	) );
	
	// Page sidebar
	register_sidebar( array(
		'name'          => __( 'Page Sidebar', 'intensely' ),
		'id'            => 'intensely-page-sidebar',
		'description'   => __( 'Add your desire widgets here. Widgets will appear in pages only.', 'intensely' ),
		'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="widgettitle widget-title">',
		'after_title'   => '</h3>',
	) );
	
}
add_action( 'widgets_init', 'intensely_widget_areas' );
 	
/*
 *	Load theme scripts & styles.
 *	Contains all necessary js & css scripts.
 *
 *	@since intensely 1.0
 */
require_once( 'inc/functions/enqueue.php' );

/*
 * Add required plugins using TGM plugin activation class
 *
 * @since intensely 1.0
 */
require_once( 'inc/functions/tgm/intensely-required-plugins.php' );

/*
 *  Add customizer settings
 *	Add kirki framework to build customizer optoins. 
 *  @link https://github.com/aristath/kirki  
 *
 *  @since intensely 1.0
 */
require_once( 'inc/functions/customizer/customizer.php' );

/**
 *  Add dynamic css
 *
 *  @since intensely 1.0
 */
 require_once( 'inc/functions/dynamic-scripts/dynamic-css.php' );
 
/**
 *  Add dynamic js
 *
 *  @since intensely 1.0
 */
 require_once( 'inc/functions/dynamic-scripts/custom-js.php' );
 
/**
 *  Theme color scheme
 *
 *  @since intensely 1.0
 */
require_once( 'inc/functions/dynamic-scripts/color-scheme.php' );
  
/**
 *  Post types
 *
 *  @since intensely 1.0
 */
 require_once( 'inc/functions/post-types.php' );
 
/**
 *  Meta boxes
 *
 *  @since intensely 1.0
 */
 require_once( 'inc/functions/meta-boxes.php' );
 
/**
 *  Add various theme necessary functions.
 *
 *  @since intensely 1.0
 */
 require_once( 'inc/functions/miscellaneous.php' );
 
  /**
  *  Commnets list template
  *
  *  @since intensely 1.0
  */
 require_once( 'inc/functions/wp_comments_list.php' );