 <?php
/**
 * The default template for displaying standard content
 *
 * Used for index/archive/search.
 *
 *	@version 1.0
 *	@since intensely 1.0
 */
?>
<!-- Start blog news single -->
<article id="post-<?php the_ID(); ?>" <?php post_class( 'blog-news-single' ); ?>>
    
    <?php if( has_post_thumbnail() ): ?>
	    <div class="blog-news-img">
	      <a href="<?php esc_url( the_permalink() ); ?>">
		      <?php the_post_thumbnail( 'post-thumbnail', array( 'alt' => esc_attr( get_the_title() ) ) ); ?>
		  </a>
	    </div>
    <?php endif; ?>
    
    <div class="blog-news-title">
	    <h2> <a href="<?php esc_url( the_permalink() ); ?>"><?php the_title(); ?></a> </h2>
		<?php get_template_part( 'post', 'meta' ); ?>
    </div>
    
    <div class="blog-news-details">
	    <?php
		    /*
			 *	Expert or full content
		     */
		     $expert_or_full_content	=	esc_html( get_theme_mod( 'intensely_blog_excerpt_full', 'intensely-excerpt' ) );
		     if( $expert_or_full_content == 'intensely-excerpt' ): ?>
		     	<p><?php echo intensely_custom_post_excerpt(); ?></p>
		     	<a class="blog-more-btn" href="<?php esc_url( the_permalink() ); ?>"><?php _e( 'Read More', 'intensely' ); ?> <i class="fa fa-long-arrow-right"></i></a>
		     <?php else: 
			     the_content();
		     endif; ?>
    </div>
    
</article>