<?php
/*
 *	TEMPLATE NAME: Contact Page
 *	
 *	Handles output for contact page
 *
 *	@version 1.0
 *	@since intensely 1.0
 */

get_header(); ?>
  
<!-- Start single page header -->
<section id="single-page-header">
	<div class="overlay">
	    <div class="container">
	        <div class="row">
		        <div class="col-md-6 col-sm-6 col-xs-12">
		            <div class="single-page-header-left">

		              <?php the_title( '<h2>', '</h2>' ); ?>
						<!-- start loop -->											
						<?php 
							if (have_posts()) :
								while (have_posts()) : the_post();
								
									the_content();
								
								endwhile;
							endif;
						?>
						<!-- end loop -->
		            </div>
		        </div>
		       
		        <?php if ( function_exists('yoast_breadcrumb') ) { ?>
			        <div class="col-md-6 col-sm-6 col-xs-12">
			            <div class="single-page-header-right">
							<!-- start breadcrumb -->
							<?php yoast_breadcrumb('<p class="breadcrumb">','</p>'); ?>
							<!-- End breadcrumb -->
			            </div>
			        </div>
		        <?php } ?>
		        
	        </div>
	    </div>
	</div>
</section>
<!-- End single page header -->
 
<?php
/*
 *	Enable/disable contact info section
 *
 *	@since intensely 1.0
 */
 $contact_section	=	esc_html( get_theme_mod( 'intensely_contact_info_enable_disable', '1' ) );
 if( $contact_section ): ?>
	<!-- Start contact section  -->
	<section id="contact">
		<div class="container">
		   <div class="row">
		     	
		     	<?php
			     	/*
				     *	Section title & description
				     *
				     *	@since intensely 1.0
			     	 */
			     	 $contact_section_title	=	esc_html( get_theme_mod( 'intensely_contact_info_section_title', '' ) );
			     	 $contact_section_desc	=	esc_textarea( get_theme_mod( 'intensely_contact_info_section_desc', '' ) );
			     	 if( $contact_section_title || $contact_section_desc ):
		     	?>
			     	<div class="col-md-12">
			           <div class="title-area">
				            <h2 class="title"><?php echo $contact_section_title; ?></h2>
				            <span class="line"></span>
				            <p><?php echo $contact_section_desc; ?></p>
			            </div>
					</div>
				<?php endif; ?>
		        
		        <div class="col-md-12">
		           <div class="cotact-area">
		             	<div class="row">
			               	
			               	<?php
				               	/*
					             *	Contact info
				               	 */
				               	 $contact_info_title	=	esc_html( get_theme_mod( 'intensely_contact_info_title', __( 'Contact info', 'intensely' ) ) );
				               	 $contact_info			=	esc_textarea( get_theme_mod( 'intensely_contact_info_desc', '' ) );
				               	 $contact_form			=	get_theme_mod( 'intensely_contact_form_shortcode', '' );
				               	 if( $contact_info_title || $contact_info ) :
			               	?>
			               	<div class="col-md-4">
				                <div class="contact-area-left">
				                   <h4><?php echo $contact_info_title; ?></h4>
				                   <p><?php echo $contact_info; ?></p>
				                </div>
							</div>
							<?php endif; ?>
							
							<?php if( $contact_form != '' ): ?>
								<div class="col-md-8">
					                <div class="contact-area-right">
						                <?php echo do_shortcode( ' '. $contact_form .' ' );?>
					                </div>
			               		</div>
		               		<?php endif; ?>
		               		
					   	</div>
		           </div>
		        </div>
			</div>
		</div>
	</section>
	<!-- End contact section  -->
<?php endif; ?>

<?php
/*
 *	Enable/disable Google map section
 *
 *	@since intensely 1.0
 */
 $google_map	=	get_theme_mod( 'intensely_google_map_embed', '1' );
 if( $google_map ): ?>
	<!-- Start google map -->
	<section id="google-map">
		<?php echo $google_map; ?>
	</section>
	<!-- Start google map -->
<?php endif; ?>

<!-- Start subscribe us -->
<?php echo get_template_part( 'inc/template-parts/subscribe', 'form' ); ?>
<!-- End subscribe us -->

<?php get_footer(); ?>