<?php
/**
 * The template for displaying archive pages
 *
 *	@version 1.0
 *	@since intensely 1.0
 */

get_header(); ?>

<!-- Start blog archive -->
<section id="blog-archive">
    <div class="container">
	    <div class="row">
	        <div class="col-md-12">
		        <div class="blog-archive-area">
						
					<?php if ( is_category() ) : ?>
						<!-- category archive -->
				        <div class="row">
					        <div class="col-md-12">
						        <h2 class="blog-archive-title"><?php single_cat_title( __( 'Archive for : ', 'intensely' ), true ); ?></h2>
					        </div>
				        </div>
						
					<?php elseif( is_tag() ) : ?>
						<!-- tag archive -->
				        <div class="row">
					        <div class="col-md-12">
						        <h2 class="blog-archive-title"><?php single_tag_title( __( 'Archive for : ', 'intensely' ), true ); ?></h2>
					        </div>
				        </div>
						
					<?php elseif( is_day() ) : ?>
						<!-- daily archive -->
				        <div class="row">
					        <div class="col-md-12">
						        <h2 class="blog-archive-title"><?php _e( 'Archive for : ', 'intensely' ); the_time( get_option( 'date_format' ) ); ?></h2>
					        </div>
				        </div>
						
					<?php elseif( is_month() ) : ?>	
						<!-- monthly archive -->
				        <div class="row">
					        <div class="col-md-12">
						        <h2 class="blog-archive-title"><?php _e( 'Archive for :  ', 'intensely' ); the_time( get_option( 'date_format' ) ); ?></h2>
					        </div>
				        </div>
						
					<?php elseif( is_year() ) : ?>
						<!-- yearly archive -->
				        <div class="row">
					        <div class="col-md-12">
						        <h2 class="blog-archive-title"><?php _e( 'Archive for :  ', 'intensely' ); echo date('Y'); ?></h2>
					        </div>
				        </div>
						
					<?php elseif( is_search() ) : ?>
						<!-- search archive -->
				        <div class="row">
					        <div class="col-md-12">
						        <h2 class="blog-archive-title"><?php printf( __( 'Results for : <span> %s</span>', 'intensely' ), get_search_query() ); ?></h2>
					        </div>
				        </div>
						
					<?php elseif( is_author() ) : ?>
						<!-- author archive -->
				        <div class="row">
					        <div class="col-md-12">
						        <h2 class="blog-archive-title"><?php _e('Posts by : ', 'intensely'); the_author(); ?></h2>
					        </div>
				        </div>
						
					<?php elseif( isset( $_GET['paged'] ) && !empty( $_GET['paged'] ) ) : ?>
						<!-- paged archive -->
				        <div class="row">
					        <div class="col-md-12">
						        <h2 class="blog-archive-title"><?php _e('Archives : ', 'intensely'); ?></h2>
					        </div>
				        </div>					
						
					<?php endif; ?>
			        
		            <div class="row">
			            <div class="col-md-8">
			                <div class="blog-archive-left">
				                
								<!-- start loop -->											
								<?php 
									if ( have_posts() ) :
									
										while (have_posts()) : the_post();
										
											get_template_part( 'content', '' );
										
										endwhile;
										
										else : 
										
											get_template_part( 'content', 'none' );
									endif;
								?>
								<!-- end loop -->
				                  
			                  
								<!-- Start blog pagination -->
								<div class="blog-pagination">
				                    <?php echo intensely_numeric_page_navi(); ?>
				                </div>
				                
				            </div>
				        </div>
				        
			            <div class="col-md-4">
				            <?php get_sidebar(); ?>
			            </div>
			            
		            </div>
		        </div>
	        </div>
	    </div>
    </div>  
</section>
<!-- End blog archive -->

<!-- Start subscribe us -->
<?php echo get_template_part( 'inc/template-parts/subscribe', 'form' ); ?>
<!-- End subscribe us -->

<?php get_footer(); ?>