<?php
/**
 *	This template is for 404 page
 *
 * 	@link http://codex.wordpress.org/Template_Hierarchy
 *
 *	@version 1.0
 *	@since intensely 1.0
 */

get_header(); ?>
  
	<!-- Start error section  -->
  	<section id="error">
	    <div class="container">
		    <div class="row">
		        <div class="col-md-12">
			        <div class="errror-page-area">
			            <h1 class="error-title"><i class="fa fa-exclamation-circle" aria-hidden="true"></i></h1>
			            <div class="error-content">
				          <?php
					          /*
						       *	404 title
					           */
					           $fzf_title	=	esc_html( get_theme_mod( 'intensely_404_title_text', __( 'Opps!', 'intensely' ) ) );
					           if( $fzf_title ):
				          ?>
			              <span><?php echo $fzf_title; ?></span>
			              <?php endif; ?>
			              
				          <?php
					          /*
						       *	404 sub-title
					           */
					           $fzf_sub_title	=	esc_html( get_theme_mod( 'intensely_404_subtitle_text', __( 'We\'re sorry, but the page you were looking for doesn\'t exist.', 'intensely' ) ) );
					           if( $fzf_sub_title ):
				          ?>
			              <p><?php echo $fzf_sub_title; ?></p>
			              <?php endif; ?>
						  
				            <?php
					            /*
						         *	Button
					             */
					            $fzf_button_text = esc_html( get_theme_mod( 'intensely_404_btn_text', __( 'Home', 'intensely' ) ) );
					            $fzf_button_url = esc_url( get_theme_mod( 'intensely_404_btn_url', home_url( '/' ) ) );
					            
					            if ( ( $fzf_button_text != '' ) && ( $fzf_button_url != '' ) ) :
					            	echo '<a href="'. $fzf_button_url .'" class="error-home"> ' . $fzf_button_text . ' </a>';
					            endif;
				            ?>
							
			            </div>
			        </div>
		        </div>
		    </div>
	    </div>
	</section>
	<!-- End error section  -->

<!-- Start subscribe us -->
<?php echo get_template_part( 'inc/template-parts/subscribe', 'form' ); ?>
<!-- End subscribe us -->

<?php get_footer(); ?>